#include <stdint.h>
#include <rt_misc.h>
#include <arm_compat.h>
 
__attribute__ ((section (".CRPSection"), used)) const long CRP_Key = -1; //Don't use Code Read Protection

extern char Image$$RW_IRAM1$$ZI$$Limit[];

__value_in_regs struct __initial_stackheap __user_setup_stackheap(uint32_t R0, uint32_t R1, uint32_t R2, uint32_t R3)
{
    uint32_t zi_limit = (uint32_t)Image$$RW_IRAM1$$ZI$$Limit;
    uint32_t sp_limit = __current_sp();

    zi_limit = (zi_limit + 7) & ~0x7;    // ensure zi_limit is 8-byte aligned

    struct __initial_stackheap r;
    r.heap_base = zi_limit;
    r.heap_limit = sp_limit;
    return r;
}
