#include "mbed.h"
#include "io.h"
 
static void timer0_IRQHandler(void)
{
    //Handle match channel 0
    if (LPC_TIM0->IR & 1)
    {
        LPC_TIM0->IR = 1; //Writing a logic one to the corresponding IR bit will reset the interrupt. Writing a zero has no effect. See 21.6.1.
    }
    //Handle match channel 1
    if (LPC_TIM0->IR & 2)
    {
        LPC_TIM0->IR = 2;
    }
    //Handle match channel 2
    if (LPC_TIM0->IR & 4)
    {
        LPC_TIM0->IR = 4;
    }
    //Handle match channel 3
    if (LPC_TIM0->IR & 8)
    {
        LPC_TIM0->IR = 8;
    }
    Led1 = !Led1
}
 
void OneWireNewSetup(int us0, int us1, int us2, int us3)
{
    LPC_TIM0->MR0  = us0;  // 21.6.7 Match Register 0       - Match count
    LPC_TIM0->MR1  = us1;  // 21.6.7 Match Register 1       - Match count
    LPC_TIM0->MR2  = us2;  // 21.6.7 Match Register 2       - Match count
    LPC_TIM0->MR3  = us3;  // 21.6.7 Match Register 3       - Match count
    LPC_TIM0->TCR  = 1;    // 21.6.2 Timer Control Register - Enable TC and PC
}

int OneWireNewInit()
{
    NVIC_SetVector  (TIMER0_IRQn,(uint32_t)&timer0_IRQHandler);
    NVIC_SetPriority(TIMER0_IRQn, 1);
    LPC_SC->PCONP |= 2;        //  4.8.9 Power Control for Peripherals register - Timer0 Power On
    LPC_TIM0->TCR  = 2;        // 21.6.2 Timer Control Register - Reset TC and PC
    LPC_TIM0->CTCR = 0;        // 21.6.3 Count Control Register - Timer mode
    LPC_TIM0->PR   = 95;       // 21.6.5 Prescale register      - Prescale 96MHz clock to 1Mhz. When PC is equal to this value, the next clock increments the TC and clears the PC
    LPC_TIM0->MCR  = 07111;    // 21.6.8 Match Control Register - Interrupt on match 2, 1, and 0; stop, reset and interrupt on match 3
    NVIC_EnableIRQ(TIMER0_IRQn); 
    return 0;
}
int OneWireNewMain() 
{
    return 0;
}
