#include "mbed.h"

static SPI device(p5, p6, p7); // mosi, miso, sclk
static DigitalOut cs(p8, 1);   // ssel

/*
| BIT 7 | BIT 6 | BIT 5 | BIT 4 | BIT 3 | BIT 2 | BIT 1 | BIT 0 |
+-------+-------+-------+-------+-------+-------+-------+-------+
|   -   |          10 Seconds   |             Seconds           | 00–59
+-------+-------+-------+-------+-------+-------+-------+-------+
|   -   |          10 Minutes   |             Minutes           | 00–59
+-------+-------+-------+-------+-------+-------+-------+-------+
|   -   |   -   |  10 Hours     |             Hours             | 00-23
+-------+-------+-------+-------+-------+-------+-------+-------+
|   -   |   -   |   -   |   -   |   -   |     Weekday           |  1-7
+-------+-------+-------+-------+-------+-------+-------+-------+
|   -   |   -   |  10 Days      |             Days              | 01-31
+-------+-------+-------+-------+-------+-------+-------+-------+
|Century|   -   |   -   | 10 Mo |             Months            | 01-12
+-------+-------+-------+-------+-------+-------+-------+-------+
|                  10 Years     |             Years             | 00-99
+-------+-------+-------+-------+-------+-------+-------+-------+
*/
static char bcdToInt(char bcd)
{
    return 0;
}
static char intToBcd(char i)
{
    return 0;
}
void ExtRtcSet(struct tm *ptm)
{
    char bcd;
    cs = 0;
    device.write(0x80); //Send address 00h
    bcd = intToBcd(ptm->tm_sec ); device.write(bcd);
    bcd = intToBcd(ptm->tm_min ); device.write(bcd);
    bcd = intToBcd(ptm->tm_hour); device.write(bcd);
    bcd =          ptm->tm_wday;  device.write(bcd);
    bcd = intToBcd(ptm->tm_mday); device.write(bcd);
    int year = ptm->tm_year;
    bcd = intToBcd(ptm->tm_mon);
    if (year > 99) bcd |= 0x80;
    device.write(bcd);
    if (year > 99) year -=100;
    bcd = intToBcd(year);
    device.write(bcd);
    cs = 1;
}
void ExtRtcGet(struct tm *ptm)
{
    char bcd;
    cs = 0;
    device.write(0x00); //Send address 00h
    bcd = device.write(0xFF); ptm->tm_sec  = bcdToInt(bcd);
    bcd = device.write(0xFF); ptm->tm_min  = bcdToInt(bcd);
    bcd = device.write(0xFF); ptm->tm_hour = bcdToInt(bcd);
    bcd = device.write(0xFF); ptm->tm_wday = bcd;
    bcd = device.write(0xFF); ptm->tm_mday = bcdToInt(bcd);
    bcd = device.write(0xFF);
    int century = bcd & 0x80;
    bcd &= 0x7F;
    ptm->tm_mon  = bcdToInt(bcd);
    bcd = device.write(0xFF);
    ptm->tm_year = bcdToInt(bcd);
    if (century) ptm->tm_year += 100;
    cs = 1;
}

int ExtRtcMain()
{
    return 0;
}
int ExtRtcInit()
{
    cs = 1;
    device.format(8, 1);
    device.frequency(1000000);
    return 0;
}