#include    "mbed.h"
#include     "cfg.h"
#include    "time.h"
#include     "log.h"
#include      "at.h"
#include     "ntp.h"
#include     "esp.h"
#include      "io.h"
#include  "server.h"
#include    "wifi.h"
#include    "uart.h"
#include  "1-wire.h"
#include "ds18b20.h"

static Timer stopTimer;

int main()
{
    int r = 0;
    
    //stopTimer.reset();
    //stopTimer.start();
    
    Led1 = 0; Led2 = 0; Led3 = 0; Led4 = 0;

    r =     CfgInit();
    r =    TimeInit();
    r =     LogInit();
    r =    UartInit();
    r =     EspInit();
    r =      AtInit();
    r =     NtpInit();
    r =  ServerInit(); //Call this after any connections (ntp) are reserved
    r = OneWireInit();
    r = DS18B20Init();
           
    while (1)
    {
        r =    WifiMain(); if (r) break;
        r =      AtMain(); if (r) break;
        r =    UartMain(); if (r) break;
        r =     EspMain(); if (r) break;
        r =     NtpMain(); if (r) break;
        r =  ServerMain(); if (r) break;
        r = OneWireMain(); if (r) break;
        r = DS18B20Main(); if (r) break;
        r =    TimeMain(); if (r) break;
        
        
        switch (WifiStatus)
        {
            case WIFI_STOPPED:   Led2 = 0; Led3 = 0; Led4 = 1; break;
            case WIFI_READY:     Led2 = 0; Led3 = 1; Led4 = 0; break;
            case WIFI_CONNECTED: Led2 = 1; Led3 = 0; Led4 = 0; break;
            case WIFI_GOT_IP:    Led2 = 0; Led3 = 0; Led4 = 0; break;
            
        }
              
        //Led1 = AtBusy();
        //if (stopTimer.read() > 20) break;
    }
    
    Led1 = 1; Led2 = 1; Led3 = 1; Led4 = 1;
    
    LogCrLf("Finished");
    LogSave();
    wait(1);
    return EXIT_SUCCESS;
}
