"//Radiator script\n"
"'use strict';\n"
"\n"
"let   hallTemperature    = '';\n"
"let   tankTemperature    = '';\n"
"let programTimerOutput   = false;\n"
"let radiatorMode         = false;\n"
"let radiatorOverride     = false;\n"
"let radiatorPump         = false;\n"
"let hotWaterProtectOn    = false;\n"
"let radiatorsOn          = false;\n"
"let overrideCancelHour = '';\n"
"let overrideCancelMinute = '';\n"
"let nightSetPoint        = '';\n"
"let frostSetPoint        = '';\n"
"let hotWaterProtectTemp  = '';\n"
"\n"
"function parse()\n"
"{\n"
"    let lines = Ajax.response.split('\\n');\n"
"    hallTemperature      = Ajax.hexToSignedInt16(lines[0]);\n"
"    tankTemperature      = Ajax.hexToSignedInt16(lines[1]);\n"
"    programTimerOutput   = Ajax.hexToBit        (lines[2],  0);\n"
"    radiatorMode         = Ajax.hexToBit        (lines[2],  1);\n"
"    radiatorOverride     = Ajax.hexToBit        (lines[2],  2);\n"
"    radiatorPump         = Ajax.hexToBit        (lines[2],  3);\n"
"    hotWaterProtectOn    = Ajax.hexToBit        (lines[2],  4);\n"
"    radiatorsOn          = Ajax.hexToBit        (lines[2],  5);\n"
"    overrideCancelHour   = Ajax.hexToSignedInt8 (lines[3]);\n"
"    overrideCancelMinute = Ajax.hexToSignedInt8 (lines[4]);\n"
"    nightSetPoint        = Ajax.hexToSignedInt16(lines[5]);\n"
"    frostSetPoint        = Ajax.hexToSignedInt16(lines[6]);\n"
"    hotWaterProtectTemp  = Ajax.hexToSignedInt8 (lines[7]);\n"
"}\n"
"function display()\n"
"{\n"
"    let elem;\n"
"    elem = Ajax.getElementOrNull('ajax-hall-html'             ); if (elem) elem.textContent =  OneWire.DS18B20ToString(hallTemperature);\n"
"    elem = Ajax.getElementOrNull('ajax-tank-html'             ); if (elem) elem.textContent =  OneWire.DS18B20ToString(tankTemperature);\n"
"    elem = Ajax.getElementOrNull('ajax-program-toggle'        ); if (elem) elem.setAttribute('dir', programTimerOutput ? 'rtl' : 'ltr');\n"
"    elem = Ajax.getElementOrNull('ajax-mode-toggle'           ); if (elem) elem.setAttribute('dir', radiatorMode       ? 'rtl' : 'ltr');\n"
"    elem = Ajax.getElementOrNull('ajax-override-toggle'       ); if (elem) elem.setAttribute('dir', radiatorOverride   ? 'rtl' : 'ltr');\n"
"    elem = Ajax.getElementOrNull('ajax-radiator-pump-toggle'  ); if (elem) elem.setAttribute('dir', radiatorPump       ? 'rtl' : 'ltr');\n"
"    elem = Ajax.getElementOrNull('ajax-hw-prot-toggle'        ); if (elem) elem.setAttribute('dir', hotWaterProtectOn  ? 'rtl' : 'ltr');\n"
"    elem = Ajax.getElementOrNull('ajax-radiators-on-toggle'   ); if (elem) elem.setAttribute('dir', radiatorsOn        ? 'rtl' : 'ltr');\n"
"    elem = Ajax.getElementOrNull('ajax-override-cancel-minute'); if (elem)\n"
"    {\n"
"        elem.value = String(overrideCancelHour*100 + overrideCancelMinute).padStart(4, '0');\n"
"    }\n"
"    elem = Ajax.getElementOrNull('ajax-night-set-point'      ); if (elem) elem.value = nightSetPoint;\n"
"    elem = Ajax.getElementOrNull('ajax-frost-set-point'      ); if (elem) elem.value = frostSetPoint;\n"
"    elem = Ajax.getElementOrNull('ajax-hw-prot-temp'         ); if (elem) elem.value = hotWaterProtectTemp;\n"
"}\n"
"\n"
"Ajax.server     = '/radiator-ajax';\n"
"Ajax.onResponse = function() { parse(); display(); };\n"
"Ajax.init();\n"
""