#include  <stdint.h>
#include   <stdio.h>

#include "http.h"
#include "boiler.h"
#include "radiator.h"
#include "ds18b20.h"
#include "program.h"
#include "1-wire-device.h"

void WebRadiatorAjax()
{
    HttpOk("text/plain; charset=UTF-8", "no-cache", NULL, NULL);
                        
    HttpAddInt16AsHex(RadiatorGetHallDS18B20Value()); HttpAddChar('\n');
    HttpAddInt16AsHex(BoilerGetTankDS18B20Value()  ); HttpAddChar('\n');
    
    int byte = 0;
    if (ProgramTimerOutput            ) byte |= 0x01;
    if (RadiatorGetWinter()           ) byte |= 0x02;
    if (RadiatorGetOverride()         ) byte |= 0x04;
    if (RadiatorPump                  ) byte |= 0x08;
    if (RadiatorGetHotWaterProtectOn()) byte |= 0x10;
    if (RadiatorsOn                   ) byte |= 0x20;
    HttpAddByteAsHex(byte);    HttpAddChar('\n');
    
    HttpAddByteAsHex (RadiatorGetOverrideCancelHour()  ); HttpAddChar('\n');
    HttpAddByteAsHex (RadiatorGetOverrideCancelMinute()); HttpAddChar('\n');
    HttpAddInt16AsHex(RadiatorGetNightTemperature()    ); HttpAddChar('\n');
    HttpAddInt16AsHex(RadiatorGetFrostTemperature()    ); HttpAddChar('\n');
    HttpAddByteAsHex (RadiatorGetHotWaterProtectTemp() ); HttpAddChar('\n');
}

