#include "lpc1768.h"
#include "periphs.h"
#include "led.h"
#include "clk.h"
#include "log.h"
#include "fram.h"
#include "net.h"
#include "1-wire.h"
#include "1-wire-device.h"
#include "heating.h"
#include "settings.h"
#include "web.h"
#include "settings.h"
#include "values.h"
#include "restart.h"
#include "restart-this.h"
#include "crypto.h"
#include "wiz.h"

int main()
{
    RestartZone = RESTART_ZONE_INIT;
            PeriphsInit();
                LedInit();
            Lpc1768Init();
                ClkInit();
                LogInit(ClkNowTmUtc, 115200);
    if (   SettingsInit()) goto end; //Uses log. Fram is initialised here
             CryptoInit();           //Uses log
                NetInit();
                WebInit();
            OneWireInit();
             DeviceInit();
            HeatingInit();
    if (     ValuesInit()) goto end;
                WizInit();
    while (1)
    {
        RestartZone = RESTART_ZONE_LOG;              LogMain();
        RestartZone = RESTART_ZONE_CLOCK;            ClkMain();
        RestartZone = RESTART_ZONE_NET;              NetMain();
        RestartZone = RESTART_ZONE_VALUES;        ValuesMain();
        RestartZone = RESTART_ZONE_ONE_WIRE; if (OneWireMain()) break;
        RestartZone = RESTART_ZONE_DEVICE;   if ( DeviceMain()) break;
        RestartZone = RESTART_ZONE_HEATING;      HeatingMain();
        RestartZone = RESTART_ZONE_LPC1768;      Lpc1768Main();
        RestartZone = RESTART_ZONE_CRYPTO;        CryptoMain();
                                                     WizMain();
    }

end:
    Led1Set(1); Led2Set(1); Led3Set(1); Led4Set(1);
    return 0;
}