#include <stdint.h>

#include "periphs.h"
#include "lpc1768.h"
#include "clk.h"
#include "time.h"
#include "log.h"
#include "net.h"
#include "settings.h"
#include "web.h"
#include "ntpserver.h"
#include "gps.h"
#include "led.h"
#include "restart.h"
#include "restart-this.h"
#include "crypto.h"

int main()
{
          RestartZone = RESTART_ZONE_INIT;
          PeriphsInit();
          Lpc1768Init();
         SettingsInit();
              ClkInit();
              LogInit(ClkNowTmUtc, 115200);
              GpsInit();
           CryptoInit();           //Uses log
              NetInit();
        NtpServerName   = "GPS";
        NtpServerEnable = true;
              WebInit();
      
    while (1)
    {   
        RestartZone = RESTART_ZONE_LOG;           LogMain();
        RestartZone = RESTART_ZONE_CLOCK;         ClkMain();
        RestartZone = RESTART_ZONE_GPS;           GpsMain();
        RestartZone = RESTART_ZONE_NET;           NetMain();
        RestartZone = RESTART_ZONE_LPC1768;   Lpc1768Main();
        RestartZone = RESTART_ZONE_CRYPTO;     CryptoMain();
    }
}