"//Nmea script\n"
"'use strict';\n"
"\n"
"const NMEA_DEG_UNIT = 10000000;\n"
"const NMEA_HGT_UNIT =  1000000;\n"
"\n"
"let gpsTrace     = false;\n"
"let gpsVerbose   = false;\n"
"let msgTrace     = false;\n"
"let cmdTrace     = false;\n"
"let lat          = 0;\n"
"let lng          = 0;\n"
"let hgt          = 0;\n"
"let hgtAboveMsl  = 0;\n"
"let mslAboveWgs  = 0;\n"
"let dop          = 0;\n"
"let satCount     = 0;\n"
"let fixQuality   = 0;\n"
"let sensorHeight = 0;\n"
"let bucketCount  = 0;\n"
"let buckets      = '';\n"
"\n"
"function parseVariables(text)\n"
"{\n"
"    let lines = text.split('\\n');\n"
"    gpsTrace     = Ajax.hexToBit        (lines[0], 0);\n"
"    gpsVerbose   = Ajax.hexToBit        (lines[0], 1);\n"
"    msgTrace     = Ajax.hexToBit        (lines[0], 2);\n"
"    cmdTrace     = Ajax.hexToBit        (lines[0], 3);\n"
"    lat          = Ajax.hexToSignedInt32(lines[1]);\n"
"    lng          = Ajax.hexToSignedInt32(lines[2]);\n"
"    hgt          = Ajax.hexToSignedInt32(lines[3]);\n"
"    hgtAboveMsl  = Ajax.hexToSignedInt32(lines[4]);\n"
"    mslAboveWgs  = Ajax.hexToSignedInt32(lines[5]);\n"
"    dop          = Ajax.hexToSignedInt32(lines[6]);\n"
"    satCount     = Ajax.hexToSignedInt32(lines[7]);\n"
"    fixQuality   = Ajax.hexToSignedInt32(lines[8]);\n"
"    sensorHeight = Ajax.hexToSignedInt32(lines[9]);\n"
"}\n"
"function parseBuckets(text)\n"
"{\n"
"    let lines = text.split('\\n');\n"
"    bucketCount  = Ajax.hexToSignedInt32(lines[0]);\n"
"    buckets      = '';\n"
"    for (let i = 0; i < bucketCount; i++)\n"
"    {\n"
"        buckets += (i * 50).toString().padStart(3, '0') + ' ' + Ajax.hexToSignedInt32(lines[i + 1]) + '\\r\\n';\n"
"    }\n"
"}\n"
"function parse()\n"
"{\n"
"    let topics = Ajax.response.split('\\f');\n"
"    parseVariables(topics[0]);\n"
"    parseBuckets  (topics[1]);\n"
"}\n"
"function degToString(plus, minus, deg)\n"
"{\n"
"    deg /= NMEA_DEG_UNIT;\n"
"    if (deg >= 0) return plus  +    deg.toFixed(5);\n"
"    else          return minus + (-deg).toFixed(5);\n"
"}\n"
"function hgtToString(plus, minus, hgt)\n"
"{\n"
"    hgt /= NMEA_HGT_UNIT;\n"
"    if (hgt >= 0) return plus  +    hgt.toFixed(1);\n"
"    else          return minus + (-hgt).toFixed(1);\n"
"}\n"
"function display()\n"
"{\n"
"   let elem;\n"
"   elem = Ajax.getElementOrNull('ajax-trace-gps'    ); if (elem) elem.setAttribute('dir', gpsTrace   ? 'rtl' : 'ltr');\n"
"   elem = Ajax.getElementOrNull('ajax-trace-verbose'); if (elem) elem.setAttribute('dir', gpsVerbose ? 'rtl' : 'ltr');\n"
"   elem = Ajax.getElementOrNull('ajax-trace-msg'    ); if (elem) elem.setAttribute('dir', msgTrace   ? 'rtl' : 'ltr');\n"
"   elem = Ajax.getElementOrNull('ajax-trace-cmd'    ); if (elem) elem.setAttribute('dir', cmdTrace   ? 'rtl' : 'ltr');\n"
"\n"
"   elem = Ajax.getElementOrNull('ajax-position'     ); if (elem) elem.textContent = degToString('N', 'S', lat) + ' ' +\n"
"                                                                                    degToString('E', 'W', lng) + ' ' +\n"
"                                                                                    hgtToString('H', 'D', hgt);\n"
"   elem = Ajax.getElementOrNull('ajax-msl-above-wgs'); if (elem) elem.textContent = hgtToString('H', 'D', mslAboveWgs);\n"
"   elem = Ajax.getElementOrNull('ajax-hgt-above-msl'); if (elem) elem.textContent = hgtToString('H', 'D', hgtAboveMsl);\n"
"   elem = Ajax.getElementOrNull('ajax-gnd-above-msl'); if (elem) elem.textContent = hgtToString('H', 'D', hgtAboveMsl - sensorHeight * NMEA_HGT_UNIT);\n"
"\n"
"   elem = Ajax.getElementOrNull('ajax-dop'          ); if (elem) elem.textContent = dop / 100;\n"
"   elem = Ajax.getElementOrNull('ajax-sat-count'    ); if (elem) elem.textContent = satCount;\n"
"   elem = Ajax.getElementOrNull('ajax-fix-quality'  ); if (elem) elem.textContent = fixQuality;\n"
"   \n"
"   elem = Ajax.getElementOrNull('ajax-sensor-hgt'   ); if (elem) elem.value       = sensorHeight;\n"
"   \n"
"   elem = Ajax.getElementOrNull('ajax-bucket-count' ); if (elem) elem.textContent = bucketCount;\n"
"   elem = Ajax.getElementOrNull('ajax-buckets' );      if (elem) elem.textContent = buckets;\n"
"}\n"
"\n"
"Ajax.server     = '/nmea-ajax';\n"
"Ajax.onResponse = function() { parse(); display(); };\n"
"Ajax.init();"