
__initial_sp        EQU     0x10008000  ; Top of RAM from LPC1768

                PRESERVE8
                THUMB

; Vector Table Mapped to Address 0 at Reset

                AREA    RESET, DATA, READONLY
                EXPORT  __Vectors
                IMPORT  __main
                IMPORT  DefaultHandler
                IMPORT  HardFaultHandler
                IMPORT  PpsHandler

__Vectors       DCD     __initial_sp              ; Top of Stack
                DCD     __main                    ; Reset Handler
                DCD     DefaultHandler            ; NMI Handler
                DCD     HardFaultHandler          ; Hard Fault Handler
                DCD     DefaultHandler            ; MPU Fault Handler
                DCD     DefaultHandler            ; Bus Fault Handler
                DCD     DefaultHandler            ; Usage Fault Handler
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     DefaultHandler            ; SVCall Handler
                DCD     DefaultHandler            ; Debug Monitor Handler
                DCD     0                         ; Reserved
                DCD     DefaultHandler            ; PendSV Handler
                DCD     DefaultHandler            ; SysTick Handler

                ; External Interrupts
                DCD     DefaultHandler            ; Watchdog Timer
                DCD     DefaultHandler            ; Timer0
                DCD     DefaultHandler            ; Timer1
                DCD     DefaultHandler            ; Timer2
                DCD     DefaultHandler            ; Timer3
                DCD     DefaultHandler            ; UART0
                DCD     DefaultHandler            ; UART1
                DCD     DefaultHandler            ; UART2
                DCD     DefaultHandler            ; UART3
                DCD     DefaultHandler            ; PWM1
                DCD     DefaultHandler            ; I2C0
                DCD     DefaultHandler            ; I2C1
                DCD     DefaultHandler            ; I2C2
                DCD     DefaultHandler            ; SPI
                DCD     DefaultHandler            ; SSP0
                DCD     DefaultHandler            ; SSP1
                DCD     DefaultHandler            ; PLL0 Lock (Main PLL)
                DCD     DefaultHandler            ; Real Time Clock
                DCD     DefaultHandler            ; External Interrupt 0
                DCD     DefaultHandler            ; External Interrupt 1
                DCD     DefaultHandler            ; External Interrupt 2
                DCD     PpsHandler                ; External Interrupt 3
                DCD     DefaultHandler            ; A/D Converter
                DCD     DefaultHandler            ; Brown-Out Detect
                DCD     DefaultHandler            ; USB
                DCD     DefaultHandler            ; CAN
                DCD     DefaultHandler            ; General Purpose DMA
                DCD     DefaultHandler            ; I2S
                DCD     DefaultHandler            ; Ethernet
                DCD     DefaultHandler            ; Repetitive Interrupt Timer
                DCD     DefaultHandler            ; Motor Control PWM
                DCD     DefaultHandler            ; Quadrature Encoder Interface
                DCD     DefaultHandler            ; PLL1 Lock (USB PLL)

                ALIGN
                END
