#include "gpio.h"
#include "log.h"

#define CS_DIR FIO0DIR(6)
#define CS_SET FIO0SET(6)
#define CS_CLR FIO0CLR(6)

//SSP1
#define CR0     (*((volatile unsigned *) 0x40030000))
#define CR1     (*((volatile unsigned *) 0x40030004))
#define DR      (*((volatile unsigned *) 0x40030008))
#define SR      (*((volatile unsigned *) 0x4003000C))
#define CPSR    (*((volatile unsigned *) 0x40030010))

void SpiInit(void)
{
    //Configure
    CR0 |= 7 << 0; //3:0 8 bit transfer
    CR0 |= 0 << 4; //5:4 SPI
    CR0 |= 0 << 6; //7:6 Mode 0
    CR0 |= 0 << 8; //divide by 1

    //Set prescaler bps = PCLK / PS ==> PS = PCLK / bps ==> PS = 96/16 = 6
    CPSR = 6; //Bit 0 must be 0. 6 ==> 16 bps which is within the 20MHz allowed by the FRAM
    
    //Select the function of the ssel pin: P0.6
    CS_SET;     //Deselect the output == CS = 1
    CS_DIR = 1; //Set the direction to 1 == output
    
    //Enable operation
    CR1 |= 2; //Enable the SSP controller
}
void SpiChipSelect(int value)
{
    if (value) CS_SET;
    else       CS_CLR;
}
void SpiWrite(char byte)
{
    DR = byte; //This loads the next frame in the TX FIFO
}
int  SpiBusy(void)
{
    return SR & 0x10; //bit 4 is BSY. This bit is 0 if the SSPn controller is idle, or 1 if it is currently sending/receiving a frame and/or the Tx FIFO is not empty.
}
char SpiRead(void)
{
    return DR & 0xFF; //This reads the oldest frame in the RX FIFO
}
char SpiTransfer(char byte)
{
    SpiWrite(byte);
    while(SpiBusy()) /*spin until not busy, at 16 bits per us or 2 bytes per us should be only 48 operations*/;
    return SpiRead();
}
