#include <stdint.h>
#include <stdbool.h>

#include "clk.h"
#include "clktime.h"

clktime ClkTimerSinceRepetitive(clktime* pLastCount)
{
    clktime thisCount = ClkNowTai();
    clktime period = thisCount - *pLastCount;    
    *pLastCount = thisCount;
    return period;
}
clktime ClkTimerSince(clktime lastCount)
{
    return ClkNowTai() - lastCount; 
}

bool ClkTimerRepetitiveTick(clktime* pLastCount, clktime interval)
{
    if (ClkNowTai() - *pLastCount >= interval)
    {
        *pLastCount += interval;
        return true;
    }
    return false;
}
