"//1wire script\n"
"'use strict';\n"
"\n"
"let allRomValues        = new Map();\n"
"let oneWireScanTime     = 0;\n"
"let oneWireLowTweak     = 0;\n"
"let oneWireFloatTweak   = 0;\n"
"let oneWireReadTweak    = 0;\n"
"let oneWireHighTweak    = 0;\n"
"let oneWireReleaseTweak = 0;\n"
"let oneWireTrace        = false;\n"
"let assignedRoms        = new Array();\n"
"let assignedNames       = new Array();\n"
"\n"
"function getAssignedName(rom)\n"
"{\n"
"    for (let i = 0; i < assignedRoms.length; i++)\n"
"    {\n"
"        if (assignedRoms[i] === rom) return assignedNames[i]; \n"
"    }\n"
"    return '';\n"
"}\n"
"\n"
"function addRomValue(line)\n"
"{\n"
"    if (line) allRomValues.set(line.substr(0, 16), line.substr(16));\n"
"}\n"
"function parseAllRomValues(topic)\n"
"{\n"
"    allRomValues.clear();\n"
"    topic.split('\\n').forEach(addRomValue);\n"
"}\n"
"function parseTimings(topic)\n"
"{\n"
"    let lines = topic.split('\\n');\n"
"    oneWireScanTime     = Ajax.hexToSignedInt16(lines[0]);\n"
"    oneWireLowTweak     = Ajax.hexToSignedInt16(lines[1]);\n"
"    oneWireFloatTweak   = Ajax.hexToSignedInt16(lines[2]);\n"
"    oneWireReadTweak    = Ajax.hexToSignedInt16(lines[3]);\n"
"    oneWireHighTweak    = Ajax.hexToSignedInt16(lines[4]);\n"
"    oneWireReleaseTweak = Ajax.hexToSignedInt16(lines[5]);\n"
"    oneWireTrace        =                       lines[6] != '0';\n"
"}\n"
"function addRom(line)\n"
"{\n"
"    if (line)\n"
"    {\n"
"        assignedRoms.push(line.substr(0, 16))\n"
"        assignedNames.push(line.substr(16));\n"
"    }\n"
"}\n"
"function parseAssigned(topic)\n"
"{\n"
"    assignedRoms  = new Array();\n"
"    assignedNames = new Array();\n"
"    topic.split('\\n').forEach(addRom);\n"
"}\n"
"function parse()\n"
"{\n"
"    let topics = Ajax.response.split('\\f');\n"
"    parseTimings     (topics[0]);\n"
"    parseAllRomValues(topics[1]);\n"
"    parseAssigned    (topics[2]);\n"
"}\n"
"function display()\n"
"{\n"
"    let elem;\n"
"    elem = Ajax.getElementOrNull('ajax-device-values');\n"
"    if (elem) \n"
"    {\n"
"        elem.textContent = '';\n"
"        for (let [key, value] of allRomValues)\n"
"        {\n"
"            elem.textContent += key;\n"
"            elem.textContent += ' '; \n"
"            elem.textContent += OneWire.DS18B20ToString(Ajax.hexToSignedInt16(value));\n"
"            elem.textContent += ' ';\n"
"            elem.textContent += getAssignedName(key);\n"
"            elem.textContent += '\\r\\n';\n"
"        }\n"
"    }\n"
"    elem = Ajax.getElementOrNull('ajax-1-wire-scan-time'    ); if (elem) elem.textContent = oneWireScanTime;\n"
"    elem = Ajax.getElementOrNull('ajax-1-wire-tweak-low'    ); if (elem) elem.textContent = oneWireLowTweak;\n"
"    elem = Ajax.getElementOrNull('ajax-1-wire-tweak-float'  ); if (elem) elem.textContent = oneWireFloatTweak;\n"
"    elem = Ajax.getElementOrNull('ajax-1-wire-tweak-read'   ); if (elem) elem.textContent = oneWireReadTweak;\n"
"    elem = Ajax.getElementOrNull('ajax-1-wire-tweak-high'   ); if (elem) elem.textContent = oneWireHighTweak;\n"
"    elem = Ajax.getElementOrNull('ajax-1-wire-tweak-release'); if (elem) elem.textContent = oneWireReleaseTweak;\n"
"    elem = Ajax.getElementOrNull('ajax-1-wire-trace'        ); if (elem) elem.setAttribute('dir', oneWireTrace ? 'rtl' : 'ltr');\n"
"\n"
"    elem = Ajax.getElementOrNull('ajax-name-0'); if (elem && assignedNames.length > 0) elem.textContent = assignedNames[0];\n"
"    elem = Ajax.getElementOrNull('ajax-name-1'); if (elem && assignedNames.length > 1) elem.textContent = assignedNames[1];\n"
"    elem = Ajax.getElementOrNull('ajax-name-2'); if (elem && assignedNames.length > 2) elem.textContent = assignedNames[2];\n"
"    elem = Ajax.getElementOrNull('ajax-name-3'); if (elem && assignedNames.length > 3) elem.textContent = assignedNames[3];\n"
"    elem = Ajax.getElementOrNull('ajax-name-4'); if (elem && assignedNames.length > 4) elem.textContent = assignedNames[4];\n"
"    elem = Ajax.getElementOrNull('ajax-name-5'); if (elem && assignedNames.length > 5) elem.textContent = assignedNames[5];\n"
"    elem = Ajax.getElementOrNull('ajax-name-6'); if (elem && assignedNames.length > 6) elem.textContent = assignedNames[6];\n"
"    elem = Ajax.getElementOrNull('ajax-name-7'); if (elem && assignedNames.length > 7) elem.textContent = assignedNames[7];\n"
"    elem = Ajax.getElementOrNull('ajax-rom-0' ); if (elem && assignedRoms.length  > 0) elem.value = assignedRoms[0];\n"
"    elem = Ajax.getElementOrNull('ajax-rom-1' ); if (elem && assignedRoms.length  > 1) elem.value = assignedRoms[1];\n"
"    elem = Ajax.getElementOrNull('ajax-rom-2' ); if (elem && assignedRoms.length  > 2) elem.value = assignedRoms[2];\n"
"    elem = Ajax.getElementOrNull('ajax-rom-3' ); if (elem && assignedRoms.length  > 3) elem.value = assignedRoms[3];\n"
"    elem = Ajax.getElementOrNull('ajax-rom-4' ); if (elem && assignedRoms.length  > 4) elem.value = assignedRoms[4];\n"
"    elem = Ajax.getElementOrNull('ajax-rom-5' ); if (elem && assignedRoms.length  > 5) elem.value = assignedRoms[5];\n"
"    elem = Ajax.getElementOrNull('ajax-rom-6' ); if (elem && assignedRoms.length  > 6) elem.value = assignedRoms[6];\n"
"    elem = Ajax.getElementOrNull('ajax-rom-7' ); if (elem && assignedRoms.length  > 7) elem.value = assignedRoms[7];\n"
"}\n"
"\n"
"Ajax.server     = '/1wire-ajax';\n"
"Ajax.onResponse = function() { parse(); display(); };\n"
"Ajax.init();\n"
""