#include "mbed.h"


AnalogIn in(A0);

#if !DEVICE_ANALOGOUT
#error You cannot use this example as the AnalogOut is not supported on this device.
#else
AnalogOut out(PA_4);
#endif

/* #if !DEVICE_FILEHANDLE
#error You cannot use this example as the FileHandle is not supported on this device.
#else
LocalFileSystem local("local");  // Create the local filesystem under the name "local"
#endif */

DigitalOut led(LED1);
DigitalOut set(PB_0);


int main()
{
/*    FILE *fp = fopen("/DETAILS.TXT", "w");  // Open "out.txt" on the local file system for writing
    fprintf(fp, "Hello World!");
    fclose(fp); */

    printf("\nAnalog loop example\n");
    printf("*** Connect A0 and PA_4 pins together ***\n");
    int i (0);
    while(i <= 10) {
        set.write(0);
        float in_value = in.read();
        for (float out_value = 0.0f; out_value < 1.1f; out_value += 0.1f) {
            // Output value using DAC
            out.write(out_value);
            wait(0.1);
            // Read ADC input
            float in_value = in.read();
            // Display difference between two values
            float diff = fabs(out_value - in_value)*3.3f;
            in_value *= 3.3f;
            out_value *= 3.3f;            
            printf("(out:%.4f V) - (in:%.4f V) = (%.4f V) ", out_value, in_value, diff);
            out_value /= 3.3f;
            in_value /= 3.3f;
            diff /= 3.3f;
            if (diff > 0.05f) {
                printf("FAIL\n");
            } else {
                printf("OK\n");
                printf("\033[1A"); // Moves cursor up of 1 line
            }
            led = !led;
            ++i;
        }
        /* in_value *= 3.3f;
        printf("(out:%.4f V)", in_value);
        ++i; */
    }
}

