#include "mbed.h"           // Pre-Processor Statement //Include header file 

//Declare variables:
AnalogIn analog_value(A0);  // Analog in signal from LDR 
InterruptIn button(A2);     // Create an object of class InterruptIn // External interrupt on pin A2
PwmOut ledpwm(A6);          // Create analog output (pulse width modulation) Object ledpwm Pin A6

volatile bool state = 0;    // Initially lamp is OFF state is 0 // Declares variable called "state" and sets its initial value to 0 // 
                            // This variable will be changed by interrupt. 
void flip()                 // Defining the function that will be called when interrupt is activated (Filp State)
{   
    state = !state; 
}


int main()                  // Start of main program
{
    float meas_r;           // Declaring data type (floating decimal point)
    float meas_Min = 0.18;  // Declaring variable (meas_Min) and setting value 
    float meas_Max = 0.48;  // Declaring variable (meas_Max) and setting value
    
    float duty_cycle = 0.0; //adjusted duty cycle 
    
    printf("\n");
    
    button.rise(&flip);     // Attach the address of the flip function to the rising edge of the interrupt signal
    
    while(1)                // Start of while loop
    {
        meas_r = analog_value.read(); // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
            
        // Display values of voltage read across A0:
        printf("\n");
        printf("measure = %f \n",meas_r);
        printf("\n");
            
        float add_var = (meas_Max-meas_r)/(meas_r-meas_Min);    // Declaring class of function (floating decimal point) 
        
        duty_cycle = fabs(1.0/(1.00+add_var));                  // Absolute value of the argument 
            
        printf("\n");
        printf("DC = %f \n", duty_cycle);
        printf("\n");
        wait(0.1);              // 100ms pause
            
        ledpwm.period_ms(10);  // PWM period is 10ms
            
        // if the state is 1, ledpwm is on 
        if(state==1)            // This is where the brightness of the led can be controlled by changing the duty cycle // Beginning of IF statement 
        {
            if (duty_cycle<0.05)   
            {
            ledpwm.write(0);
            }
                    
            else 
            {
            ledpwm.write(duty_cycle);       // Changing duty cycle in proportion to the read LDR value // Write value to ledpwm
            }
            wait(0.2);        // 200ms pause 
        }                       // End of IF statement
                        
        // Or if the state is 0, turn the ledpwm off:
        else
        {
        ledpwm.write(0);
        }
    }               // End of while loop 
}                   // End of main program
                                       