/*SISTEMA DE ALARMA PARA CARRO CON DETECCIÓN EN 5 PUERTAS V1.0

DESARROLLADORES: Andrés Felipe Lozano
                 Juan Felipe Gamarra     */

#include "mbed.h"

Timeout crono;  //Variable encargada de activarse después de X tiempo

//SALIDAS PINES
DigitalOut verde(PTC7,1);  //LED INDICADOR VERDE
DigitalOut buzzer(PTC0,1); //PIN DONDE DEBE IR EL BUZZER

//ENTRADAS PINES
InterruptIn sw1(PTA13); //Puerta uno
InterruptIn sw2(PTD5); //Puerta dos
InterruptIn sw3(PTD0); //Puerta tres
InterruptIn sw4(PTD2); //Puerta cuatro
InterruptIn sw5(PTD3); //Puerta cinco
InterruptIn onoffcar(PTD1); //Botón ON/OFF del auto
InterruptIn panico(PTA1); //Botón depánico
InterruptIn StarStop(PTA2); //Star/Stop

//VARIABLES BOOLEANAS
bool star=true;
bool aux1,aux2, aux3;

/* INICIO DECLARACIÓN DE MIS FUNCIONES */

void onoffalarma(){
     star=!star;
     wait(1); //Elimina rebotes en el botón
    }

void puertas(){                            //Proceso que se ejecutará al llamar la función puertas
  while(1){
  buzzer = 1;
  verde=0;
    wait(0.05);
    buzzer = 0;
    wait(0.05);
    aux1 = StarStop.read(); 
    if (aux1 == 0){
        NVIC_SystemReset ();    //Parámetro reservado de mbed para reiniciar mi tarjeta 
    }   
  }
 }
 
 void carro(){ //FUNCIÓN ENCENDIDO CARRO
 verde = !verde;
 wait(1);
       if(sw1==0){ 
          buzzer=0;
       }
}
 
 void SOS(){ //FUNCIÓN BOTÓN PÁNICO
     while(1){
          buzzer = 1;
          verde=0;
          wait(0.05);
          buzzer = 0;
          wait(0.05);
          aux1 = StarStop.read(); 
               if (aux1 == 0){
                   NVIC_SystemReset ();
               }   
     }
}
/*FIN DECLARACIÓN DE MIS FUNCIONES */

int main() {
    StarStop.fall(&onoffalarma);
    buzzer=0;
    verde=0;  
    onoffcar.rise(&carro);
                                   
while(1){
                  
          if(star){
             buzzer=0; 
          }
          else{ }
         
          if(verde==1){ //Si el led verde está encendido entonces anulará la ejecución de activar la alarma así opriman las puertas
                      sw1.fall(NULL); //Flancos de bajada 
                      sw2.fall(NULL); 
                      sw3.fall(NULL);
                      sw4.fall(NULL);
                      sw5.fall(NULL);
                   } 
                   else{ 
                       sw1.fall(&puertas);
                       sw2.fall(&puertas);
                       sw3.fall(&puertas);
                       sw4.fall(&puertas);
                       sw5.fall(&puertas); 
                       }
 
              
          if(verde==1){ //Si el led verde está encendido entonces ejecutará lo siguiente
                   if(panico==0){              //Si se pulsa el botón de pánico ejecutará la acción del TIMEOUT que llama la función SOS    
                      crono.attach(&SOS, 3.0); //Ejecuta después de 10 segundos 
                   }
          }          
          
}
}