#include "mbed.h"
#include "main.h"

Serial command(USBTX, USBRX); // leer comnunicacion serial

int main() {
    init_servo();  // inicializar servo
    init_serial();  //inicializar periodo de servos

    debug_m("inicio \n");
    uint32_t read_cc;       // definimos los 4 numeros hexadecimales enviados
    while(1)
    {
        read_cc=read_command();         // leemos los 4 numeros hexadecimales enviados
        switch (read_cc) {
            case  0x01: moving(); break;
            //default: debug_m("error de comando. \nSe espera  0xFEF0 o 0xFFF0 \n");break ;      
        }
    }
}



uint32_t read_command()
{
   // retorna los byte recibidos concatenados en un entero, 
       
    char intc=command.getc();
        while(intc != 0x000000ff)       // despues de leer 0xff lee los 4 datos
        intc=command.getc();
    return command.getc();
}


void init_serial()
{
    command.baud(9600);    // leer en el monitor serial
}


void moving(){
    debug_m("se inicia el comado mover..\n");    
    
    char nmotor=command.getc();     // se asigna el 2 valor hexadecimal al numero de servo
    char grados=command.getc(); // se asigna el 3 valor hexadecimal al numero de grados
    char endc=command.getc();       // se asigna el 4 valor hexadecimal para terminar de leer la comunicacion
    mover_ser(nmotor,grados);       // llama el void mara mover servo con grados
    debug_m("fin del comado guardar..\n");    
    
}

void debug_m(char *s , ... ){
    #if DEBUG
    command.printf(s);      // imprime en el monitor serial
    #endif  
}