/* mbed Microcontroller Library
 * Copyright (c) 2006-2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __BLE_TEMPERATURE_TABLE_H__
#define __BLE_TEMPERATURE_TABLE_H__

template <typename BeaconIDType, typename TemperatureType, unsigned MAX_SIZE>
class TemperatureTable {
public:
    TemperatureTable(void) : totalBeacons(0), hasUpdatedData(true), tempValues(), beaconIds() {
        /* empty */
    }

    /* Add temperature to the table IF AND ONLY IF the data is not already there */
    void addBeacon(BeaconIDType beaconId, TemperatureType temperature) {
        for (unsigned i = 0; i < totalBeacons; i++) {
            if (beaconId == beaconIds[i]) {
                if (tempValues[i] != temperature) { /* Update old temperature value */
                    tempValues[i]  = temperature;
                    hasUpdatedData = true;
                }
                return;
            }
        }

        /* The beacon doesn't exist in the table; add an entry if there is space. */
        if (totalBeacons < MAX_SIZE) {
            beaconIds[totalBeacons]  = beaconId;
            tempValues[totalBeacons] = temperature;
            totalBeacons++;
            hasUpdatedData = true;
        }
    }

    
    TemperatureType *getTemperatures(void) {
        return tempValues;
    }

    size_t getTotalBeacons(void) const {
        return totalBeacons;
    }

    BeaconIDType *getBeaconIds(void) {
        return beaconIds;
    }

    bool hasUpdate(void) const {
        return hasUpdatedData;
    }

    void resetHasUpdate(void) {
        hasUpdatedData = false;
    }

private:
    size_t          totalBeacons;
    bool            hasUpdatedData;
    TemperatureType tempValues[MAX_SIZE];
    BeaconIDType    beaconIds[MAX_SIZE];
};

#endif /* #ifndef __BLE_TEMPERATURE_TABLE_H__ */
