#include "mbed.h"
#include "rtos.h"
#include "Servo.h"
#include "HCSR04.h"
#include "MFRC522.h"
#include "ssd1306.h"

MFRC522    RfChip   (D11, D12, D13, PTE0, D10);
SSD1306 lcd (D7,D6);
BusOut display7Seg(PTC10, PTC7, PTC6, PTC4, PTC0, PTB19, PTB18);
DigitalOut display1(PTC11);
DigitalOut display2(PTC13);
DigitalOut display3(PTC16);
Servo myservo(D2);

Thread t;
Thread t1;
Thread t2;
Thread t3;
Thread t4;

Serial pc(USBTX, USBRX);
HCSR04 sonar(D3,D4);

float menor;
float da;
float dis = 0.0;
static const char tar[]={0xD7,0x4F,0x88,0x19};
static const char llav[]={0x27,0x57,0xC1,0x7B};
int q,a,al,b,w;


int anodeComun[10] = {
    0b0000001, // 0
    0b1001111, // 1
    0b0010010, // 2
    0b0000110, // 3
    0b1001100, // 4
    0b0100100, // 5
    0b0100000, // 6
    0b0001111, // 7
    0b0000000, // 8
    0b0001100, // 9
};

void  servo()
{

    while(true) {
        menor = sonar.getCm();
        for(int i=0; i<40; i++) {
            myservo = i/40.0;
            da  = sonar.getCm();
            w=i;
            //pc.printf("%1.f  ,  %.2f \n\r",float(i*4.5),da);
            if(menor > da) {
                menor = da;
                a=(i*180)/40;
            }
            //ThisThread::sleep_for(500);
            wait(0.05);
        }
        menor=sonar.getCm();
        a=0;
        for(int i=40; i>0; i--) {
            myservo = i/40.0;
            da = sonar.getCm();
              w=i;
            // pc.printf("%1.f  ,  %.2f \n\r",float(i*4.5),da);
            if(menor > da) {
                menor = da;
                a=(i*180)/40;
            }
            //ThisThread::sleep_for(500);
            wait(0.05);
        }
    }
}
void seg7()
{
    while(1) {
        int d,u,n,c;
        n=int(menor);

        c=  n/100;
        d = (n - (c*100))/10;
        u = n % 10;

        display1=1;
        display2=0;
        display3=0;
        display7Seg=anodeComun[c];

        //ThisThread::sleep_for(25);
        wait(0.003);

        display1=0;
        display2=1;
        display3=0;
        display7Seg=anodeComun[d];

        //ThisThread::sleep_for(25);
        wait(0.003);

        display1=0;
        display2=0;
        display3=1;
        display7Seg=anodeComun[u];

        //ThisThread::sleep_for(25);
        wait(0.003);


    }
}
void oled()
{
    while(1) {
        lcd.init();
        lcd.speed (SSD1306::Fast);
        lcd.cls();
        lcd.locate (4,1);
        lcd.printf ("dis menor :%2.f ",menor);
        lcd.locate (5,1);
        lcd.printf ("angulo :%d ",a);
        lcd.locate (1,0);
        time_t seconds = time(NULL);
        lcd.printf("Fecha= %s", ctime(&seconds));
        lcd.redraw();
        //ThisThread::sleep_for(500);
        wait(0.5);
    }
}
void rf()
{
    while(1) {
        al=0;
        b=0;
        lcd.init();
        lcd.speed (SSD1306::Fast);
        if ( ! RfChip.PICC_IsNewCardPresent()) {
            //ThisThread::sleep_for(500);
            wait_ms(500);
            continue;
        }
        if ( ! RfChip.PICC_ReadCardSerial()) {
            //ThisThread::sleep_for(500);
            wait_ms(500);
            continue;
        }
        uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
        lcd.locate (6,3);
        lcd.printf(" %s ", RfChip.PICC_GetTypeName(piccType));
        lcd.redraw();
         for (uint8_t i = 0; i < RfChip.uid.size; i++) {
            
         if(uint8_t (tar[i])==RfChip.uid.uidByte[i]){
            al=al+1;
            }else{
                al=0;
                }
        }
         for (uint8_t i = 0; i < RfChip.uid.size; i++) {
            
         if(uint8_t (llav[i])==RfChip.uid.uidByte[i]){
            b=b+1;
            }else{
                b=0;
                }
        }
     
        //ThisThread::sleep_for(1000);
        wait_ms(1000);
    }
}
void serial()
{
    while(1) {

        time_t seconds = time(NULL);

        char buffer2[32];
        strftime(buffer2, 32, "%m/%d/%y", localtime(&seconds));
        pc.printf("%s", buffer2);

        char buffer1[32];
        strftime(buffer1, 32, "%H:%M:%S", localtime(&seconds));
        pc.printf(" , %s", buffer1);
        pc.printf(" , %1.f  ,  %.2f , ",float(w*4.5),da);
           if(al==4){
        pc.printf("tarjeta");  
            }else if(b==4){ 
                pc.printf("llavero");
                }else{
                   pc.printf("sin lectura"); 
                    }  
        pc.printf("\n\r");
        wait(0.04);
        
    }
}
int main()
{
    myservo.calibrate(0.0015,180);
    set_time(1591673863);
    RfChip.PCD_Init();
    t.start((servo));
    t.set_priority (osPriorityNormal3);
    t1.start(seg7);
    t1.set_priority (osPriorityNormal);
    t2.start(oled);
    t2.set_priority (osPriorityNormal1);
    t3.start(serial);
    t2.set_priority (osPriorityNormal2);
    t4.start(rf);
    t.join();
}