#include "mbed.h"
#include "C12832.h"
#include "LM75B.h"
#include "MMA7660.h"
#include "rtos.h"
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"

//------------------------------------------------------------------------//
// Hardware Variables                                                     //
//------------------------------------------------------------------------//
Serial      rn41    (p9,p10);
C12832      lcd     (p5, p7, p6, p8, p11);
BusIn       up      (p15);
BusIn       down    (p12);
BusIn       left    (p13);
BusIn       right   (p16);
BusIn       center  (p14);
DigitalOut  led1    (LED1);
DigitalOut  led2    (LED2);
DigitalOut  led3    (LED3);
DigitalOut  led4    (LED4);
LM75B       sensor  (p28,p27);
MMA7660     MMA     (p28,p27);
AnalogIn    pot1    (p19);
AnalogIn    pot2    (p20);
PwmOut      spkr    (p26);
Serial      tty_usb (USBTX, USBRX);
PwmOut r (p23);
PwmOut g (p24);
PwmOut b (p25);

Ticker t;
char tty_buffer[100];
int buffer_ptr;
int speaker_on, period_spkr;
float spkr_volume;
int user_is_back;
//------------------------------------------------------------------------//
// Function Headears                                                      //
//------------------------------------------------------------------------//
void    receive_command     ();
float   read_temp           ();
void    bluetoothReceive    ();
void    setupBluetooth      ();
void    userpcinterface_thread  (void const *args);
void    setupBluetooth          (void const *args);
void    fsleep              ();


char buff[100];

//------------------------------------------------------------------------//
// Functions                                                              //
//------------------------------------------------------------------------//


void receive_command()
{
    buffer_ptr = 0;
    char ch;
    memset(tty_buffer, '\0', sizeof(tty_buffer));
    tty_usb.putc('>');
    while (1) {
        if (tty_usb.readable()) {
            ch = tty_usb.getc();
            tty_usb.putc(ch);

            tty_buffer[strlen(tty_buffer)] = ch;
            buffer_ptr++;
            if ((ch == '\n') || (ch == '\r')) {
                tty_usb.putc('\n');
                tty_usb.putc('\r');
                break;
            }
            if (ch == 0x7f) {
                buffer_ptr -= 2;
                tty_usb.putc(0x8);
                tty_usb.putc(' ');
                tty_usb.putc(0x8);
            }
        }
    }
}



float read_temp()
{
    if (sensor.open()) {
        return sensor;
    } else {
        error("Device not detected!\n");
        return -1;
    }
}




void bluetoothReceive   ()
{
    char caracter;
    char msg[10];
    int flag_clear=0;
    float t, pot;
    if (rn41.readable()) {
        caracter = rn41.getc();
        buff[strlen(buff)]= caracter;
    }


    if(strcmp(buff, "temp") == 0) {
        flag_clear = 1;
        t = read_temp();
        sprintf(msg, "Temperatura %f", t);
        rn41.printf(msg);

    } else if(strcmp(buff, "hum") == 0) {
        pot = pot1;
        sprintf(msg, "Humidade %f", pot);
        rn41.printf(msg);
        flag_clear = 1;
    } else if(strcmp(buff, "lum") == 0) {
        pot = pot2;
        sprintf(msg, "Luminosidade %f", pot);
        rn41.printf(msg);
        flag_clear = 1;
    } else if(strcmp(buff, "speaker on") == 0) {
        period_spkr = 6000;
        spkr.period(1.0/period_spkr);
        spkr=0.5;
        spkr_volume=0.5;
        speaker_on = 1;
        flag_clear = 1;
    } else if(strcmp(buff, "speaker off") == 0) {
        spkr = 0;
        speaker_on = 0;
        spkr_volume=0;
        flag_clear = 1;
    } 
    if((!rn41.readable() && flag_clear == 1) || strlen(buff)>11) {
        memset (buff,'\0',sizeof(buff));
        flag_clear = 0;
    }


}

void setupBluetooth     (void const *args)
{
    while(1) {
        bluetoothReceive();
    }

}

void userpcinterface_thread (void const *args)
{
    tty_usb.baud(9600);
    float temper, pot;
    while(1) {
        receive_command();
        if (strncmp("temp", tty_buffer, buffer_ptr-1) == 0) {
            temper = read_temp();
            tty_usb.printf("#\tValor Temperatura = %f C", temper);
        } else if(strncmp("pot1", tty_buffer, buffer_ptr-1) == 0) {
            pot = pot1;
            tty_usb.printf("#\tValor Potenciometro1 = %f", pot);
        } else if(strncmp("pot2", tty_buffer, buffer_ptr-1) == 0) {
            pot = pot2;
            tty_usb.printf("#\tValor Potenciometro2 = %f", pot);
        } else if(strncmp("speaker on", tty_buffer, buffer_ptr-1) == 0) {
            period_spkr = 6000;
            spkr.period(1.0/period_spkr);
            spkr=0.5;
            spkr_volume=0.5;
            speaker_on = 1;
            tty_usb.printf("#\tSpeaker is o\n");
        }else if(strncmp("speaker off", tty_buffer, buffer_ptr-1) == 0) {
            spkr = 0;
            speaker_on = 0;
            spkr_volume=0;
            tty_usb.printf("#\tSpeaker volume set to 0\n");
        } else tty_usb.printf("#\tUnknown command...try again.\n");

    }
}





//------------------------------------------------------------------------//
// Main                                                                   //
//------------------------------------------------------------------------//
int main()
{
    float  Zaxis_p,  Zaxis_n;
    r.period(0.001);
    memset (buff,'\0',sizeof(buff));
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("SER group 2 board!");
    rn41.baud(115200);
    rn41.format(8,SerialBase::None,1);    
    Thread t1(userpcinterface_thread,0,osPriorityNormal);
    Thread t2(setupBluetooth,0,osPriorityNormal);
    while(1) {
        
        
        
        while (MMA.testConnection()!=1) {
        }

        Zaxis_p = MMA.z();
        Zaxis_n = -MMA.z();
        /*lcd.cls();
        lcd.locate(0,3);
        sprintf(buf, "Z_p-%f  Z_n-%f", Zaxis_p,Zaxis_n);
        lcd.printf(": %s",buf);*/
        wait(0.1);
        led2 = !led2;
        if(speaker_on) {
            if(up) {
                period_spkr+=100;
                spkr.period(1.0/period_spkr);
                wait(0.1);
            }
            if(down) {
                period_spkr-=100;
                spkr.period(1.0/period_spkr);
                wait(0.1);
            }
            if(left) {
                if(spkr_volume <0.5)
                {
                    spkr_volume+=0.05;
                    spkr = spkr_volume;                
                    wait(0.1);
                }
            }
            if(right) {
                if(spkr_volume >0)
                {
                    spkr_volume -= 0.05;
                    spkr = spkr_volume;                
                    wait(0.1);
                }
            }
        }
        r = 1.0 - Zaxis_p;
        g = 1.0 - Zaxis_n;
        b = Zaxis_p;
        //Thread:wait(osWaitForever)


    }



}


