#include "mbed.h"

#define FALSE 0
#define TRUE 1

Serial pc(USBTX, USBRX); // tx, rx

// function to convert a char buffer to decimal inetger
int char_to_int (const char *char_p, const int size)
{
    int tmp = 0;
    int pot_ten=1;
    for ( int i= (size -1); i >= 0 ; i-- ) {
        tmp = int( tmp + ( ( int(char_p[i]) - 48 ) * pot_ten ));
        pot_ten*=10;
    }
    return tmp;
}


// check if the input is valid
bool si_check_valid(const char & input)
{
    if ( ( ( int(input) > 57) || ( int(input) < 48) ) && (input != '+') && (input != '-') && (input != '*') && (input != '/') && (input != '^') && (input != '=') ) {
        return FALSE;
    } else {
        return TRUE;
    }
}

//check if the input is a number
bool si_check_number(const char & input)
{
    if ( (int(input) >= 48) && ( int(input) <= 57) ) {
        return TRUE;
    } else {
        return FALSE;
    }
}

//global variables
char c;
char op = '=';
char operand [100];
char buf[10];
int result =0;
int result_copy=0;
int index = 0;
int ioperand =0;
bool first = TRUE;
bool sign_check = TRUE;
bool neg_operand = FALSE;
bool error=FALSE;

// serial interrupt callback function
void callback()
{
    while(1) {

        c=pc.getc();  //get serial input

        if (!si_check_valid(c)) { // Invalid Input
            pc.putc(c);
            printf ("Invalid Input!\n");
        } else if (si_check_number(c)) { // Operand has been entered
            pc.putc(c);
            operand[index] = c;
            index++;
            sign_check = FALSE;  //sign check disactivated
        } else { //Operator has been entered

            if(!sign_check) {
                pc.putc('\n');
                pc.putc(c);
                pc.putc('\n');

                // sign adjustment
                if(neg_operand) {
                    ioperand = -(char_to_int(operand,index));
                } else {
                    ioperand = char_to_int(operand,index);
                }


                if (first) {  //First operator
                    result = ioperand;
                    first = FALSE;
                } else { //Do calculation

                    if(op == '+') {
                        result = int (result + ioperand);
                    } else if (op == '-') {
                        result = int (result - ioperand);
                    } else if (op  == '/') {
                        result = int (result / ioperand);
                    } else if (op == '*') {
                        result = int (result * ioperand);
                    } else if (op == '^') {
                        if(!neg_operand) {
                            result_copy = result;
                            for(int i = (abs(ioperand) -1); i>0; i--) {
                                result *=result_copy;
                            }
                        } else {
                            pc.printf("ERROR:Negative exponent");
                            error = TRUE;
                        }
                    }

                    if (c == '=') { // Operator = has been entered--> Print result and reset calculator
                        for (int j =9; j>=0; j--) {
                            buf[j]='\0';
                        }
                        if(!error) {
                            sprintf(buf, "%d", result);
                            pc.printf("%s", buf);
                        }
                        pc.printf("\n\n");
                        pc.printf("Please enter a new operation:\n");
                        first = TRUE;
                        error = FALSE;
                    }
                }
                op = c;  // assign the operator
                index=0; // reset the operand
                sign_check = TRUE; // sign check activated
                neg_operand=FALSE;
            } else {
                pc.putc(c);
                if (c=='-') {
                    neg_operand=TRUE;
                    sign_check = FALSE;
                } else if (c=='+') {
                    neg_operand=FALSE;
                    sign_check = FALSE;
                } else {
                    pc.printf("ERROR:Two consecutive Operators entered");
                    error = TRUE;
                }
            }
        }
    }
}

// MAIN
int main()
{
    pc.attach(&callback,Serial::RxIrq);

    pc.printf("LPC Integer Calculator!\n");
    pc.printf("Please enter a new operation:\n");
    while (1) {}
}