#include "types.h"

#ifndef _RING_BUF_H_
#define _RING_BUF_H_

typedef struct{
    uint8* p_o;                 /**< Original pointer */
    uint8* p_e;                 /**< End boundary */
    uint8* volatile p_r;        /**< Read pointer */
    uint8* volatile p_w;        /**< Write pointer */
    volatile uint16 fill_cnt;   /**< Number of filled slots */
    volatile uint16 size;                /**< Buffer size */
}ringbuf_t;

uint8 ICACHE_FLASH_ATTR ringbuf_init(ringbuf_t *r, uint8* buf, uint16 size);
uint8 ICACHE_FLASH_ATTR ringbuf_clear(ringbuf_t *r);
uint8 ICACHE_FLASH_ATTR ringbuf_put(ringbuf_t *r, uint8 c);
uint8 ICACHE_FLASH_ATTR ringbuf_get(ringbuf_t *r, uint8 * c);
uint16 ICACHE_FLASH_ATTR ringbuf_gets(ringbuf_t *r, uint8 * buff, uint16 size);
uint16 ICACHE_FLASH_ATTR ringbuf_puts(ringbuf_t *r, uint8 * buff, uint16 size);

#endif
