#include "mbed.h"
#include "types.h"
#include "rtos.h"

#if 0

CAN HSCAN(p30, p29);
uint32 id;
volatile uint32 available = 0;
Thread canThread;

void can_init(void)
{
    //thread.start();    
}

void can_bus_rx_IRQ()
{
    uint8 msg_raw[12];
    CANMessage msg;
    if(HSCAN.read(msg))
    {
       msg_raw[0] = (uint8)(msg.id >> 24);
       msg_raw[1] = (uint8)(msg.id >> 16);
       msg_raw[2] = (uint8)(msg.id >> 8);
       msg_raw[3] = (uint8)(msg.id >> 0);
       for(int i=0;i<8;i++)
        msg_raw[i+4] = msg.data[i];
    }
}

void can_bus_configure(uint32 txID,uint32 rxID,uint32 speed)
{
    available = 0;
    HSCAN.reset();
    wait(2); // wait for 2 seconds
    HSCAN.frequency(speed);
    HSCAN.filter(rxID,0xFFFFFF);
    HSCAN.attach(can_bus_rx_IRQ,CAN::RxIrq);
    id = txID;
}

void can_bus_send(uint8 * message, uint8 dlc=8)
{
    CANMessage msg;
    msg.id = id;
    msg.len = dlc;
    for(int i=0;i<dlc;i++) msg.data[i] = message[i];
    HSCAN.write(msg);
}

CANMessage can_bus_receive(void)
{
    if(available)
    {
        
    }
}

uint32 can_bus_available(void)
{
    return available;
}

#endif