#include "mbed.h"
#include "rtos.h"
#include "ringbuf.h"
#include "serial_bus.h"
#include "can_bus.h"

Serial pc(USBTX, USBRX);

DigitalOut reset(p21);
DigitalOut enable(p22);
DigitalOut reflash(p23);

void main() {
   
    pc.baud(115200);
    
    /* setup the system before using it */
    reset = 0;
    enable = 1;
    reflash = 1;
    
    wait(0.1);
    reset = 1;
    wait(2.0);
    pc.printf("mbed boot up... \r\n");
    
    start_serial_bus();
    
    while(1) 
    {
        Thread::wait(100);
        }
}
