#include "mbed.h"

SPI spi(p11, p12, p13); // mosi, miso, sclk
DigitalOut cs(p28); // chip select
DigitalOut ifsel1(p26); // interface select pin for  CLRC6630
DigitalOut pdres(p27); // CLRC6630 RESET pin - H = RESET
DigitalOut led[] = {(LED1) , (LED2) , (LED3) , (LED4)}; // onboard LEDs
Serial pc(USBTX, USBRX); // tx, rx

char r;
int w = 0;
char UID0 , UID1 , UID2 , UID3 , UID4, UID5 , UID6 , UID7 , UID8 , UID9, UID10;

 
//write SPI registers    
void write_reg(char n, char o)
{
 
    cs=0; // device select
    
    spi.write (n<<1);
    spi.write (o);
    
    cs=1; // device deselect
 }
 

// read SPI registers
char read_reg(char n)
{
    char t;
    cs=0; // device select
    
    
    spi.write ((n<<1)|0x01);
    t=spi.write (0);
        
    cs=1; // device deselect
    
    return t;
 }
 

//> Terminate any running command. Flush_FiFo
void terminate_and_flush_FiFo()
{
   write_reg( 0x00, 0x00 );
   write_reg( 0x02, 0xB0 );
}


// Clear all IRQ 0,1 flags
void clear_IRQ()
{
   write_reg( 0x06, 0x7F );
   write_reg( 0x07, 0x7F );
} 


// Disable Irq 0,1 sources
void disable_IRQ()
{
   write_reg( 0x08, 0x00 );       
   write_reg( 0x09, 0x00 );
}


//> Wait until the command is finished. Enable IRQ sources.
void wait_command_and_enable_IRQ()
{
   write_reg( 0x08, 0x18 );         // Enable Irqs 0,1
   write_reg( 0x09, 0x42 );         // Enable the global IRQ to be propagated to the IRQ pin
            
   while( (read_reg( 0x07 ) & 0x40)==0);
}


// Read IRQ 0,1 Status register
void read_IRQ_status()
{
   r = read_reg( 0x06 );
   r = read_reg( 0x07 );
}


// Start tranceive command
void start_tranceive()
{
    write_reg( 0x00, 0x07 );
    wait(0.01);
}

 
 int main() {
    
    while (1) {
 
        //  start activity LED;
        led[3] = 0;
        led[2] = 0;
        led[1] = 0;
        led[0] = 1;
                
        // set the comunication method
        //ifsel1 = 0; // usare questa istruzione per le schede revisione prototipo
        ifsel1 = 1; // usare questa istruzione per le schede revisione B
        wait(0.001);
    
        // SPI comunication settings
        spi.format(8,0);
        spi.frequency(1000000);
        
            do {
                              
                w = 0;
    
                    do {

                        //RESET the device
                        pdres = 1;
                        wait(0.001);
                        pdres = 0;
    
                        wait(0.005);
        

                        //> --------------------------------
                        //write_reg( 0x37, 0xFF );

                        //> =============================================
                        //> Load Protocol (ISO15693)
                        //> =============================================

                        write_reg( 0x0F, 0x98 ); // Configure T0
                        write_reg( 0x14, 0x92 ); // Configure T1 and cascade it with T0
                        write_reg( 0x19, 0x20 ); // Configure T2 for LFO AutoTrimm 
                        write_reg( 0x1A, 0x03 ); // T2 reload value for LFO AutoTrimm
                        write_reg( 0x1B, 0xFF );
                        write_reg( 0x1E, 0x00 ); // Configure T3 (for LPCD/ AutoTrimm) 
                        write_reg( 0x02, 0x90 ); // Set FiFo-Size and Waterlevel
                        write_reg( 0x03, 0xFE );
                        write_reg( 0x0C, 0x80 ); // Init. RxBitCtrl register
                        write_reg( 0x28, 0x80 );
                        write_reg( 0x29, 0x00 ); // Init. TxAmp register 
                        write_reg( 0x2A, 0x01 ); // Init. DrvCon register
                        write_reg( 0x2B, 0x05 ); // Init. TxI register
                        write_reg( 0x34, 0x00 ); // Init RxSOFD register 
                        write_reg( 0x38, 0x12 ); // Init. RCV register

                        //> Terminate any running command. Flush_FiFo
                        terminate_and_flush_FiFo();

                        // Clear all IRQ 0,1 flags
                        clear_IRQ();

                        // Write in FIFO "Load protocol" params(TxProtocol=Iso15693(0a), 0xRxProtocol=Iso15693(0a),
                        write_reg( 0x05, 0x0A );
                        write_reg( 0x05, 0x0A );

                        // Idle interrupt(Command terminated), RC663_BIT_IDLEIRQ=0x10
                        r = read_reg( 0x08 );
                        write_reg( 0x08, 0x10 ); // Enable IRQ0, 0xIRQ1 interrupt sources

                        // Enable Global IRQ propagation.
                        r = read_reg( 0x09 );
                        write_reg( 0x09, 0x40 );
                        wait(0.001);
                        r = read_reg( 0x09 );

                        //> Start RC663 command "Load Protocol"=0x0d
                        write_reg( 0x00, 0x0D ); // Execute Rc663 command: "Load protocol"

                        //SLP 100
                        wait(0.1);

                        // Disable Irq 0,1 sources
                        disable_IRQ();

                        write_reg( 0x02, 0xB0 ); // Flush FIFO

                        //> Apply RegisterSet
                        write_reg( 0x2C, 0x7B );
                        write_reg( 0x2D, 0x7B );
                        write_reg( 0x2E, 0x08 );
                        write_reg( 0x2F, 0x00 );
                        write_reg( 0x30, 0x00 );
                        write_reg( 0x31, 0x00 );
                        write_reg( 0x33, 0x0F );
                        write_reg( 0x35, 0x02 );
                        write_reg( 0x37, 0x4E );
                        write_reg( 0x39, 0x04 );
                        write_reg( 0x36, 0x8C ); // Set the RxWait register 
                        write_reg( 0x31, 0xC0 );
                        write_reg( 0x32, 0x00 );

                        // Write Timer-0, 0xTimer-1 reload values(high,low)
                        write_reg( 0x10, 0x18 );
                        write_reg( 0x11, 0x86 );
                        write_reg( 0x15, 0x00 );
                        write_reg( 0x16, 0x00 );
                        write_reg( 0x29, 0x0A );
                        write_reg( 0x28, 0x81 );
                        write_reg( 0x0B, 0x00 ); // Disable MIFARE Crypto1

                        //> =============================================
                        //> FieldOn
                        //> =============================================
                        write_reg( 0x28, 0x89 );
                        wait(0.1);

                        //> =============================================
                        //> ActivateCard
                        //> =============================================

                        // Set short timeout. Timer-0,Timer-1 reload values(hi,lo) 
                        write_reg( 0x10, 0x24 );
                        write_reg( 0x11, 0xEB );
                        write_reg( 0x15, 0x00 );
                        write_reg( 0x16, 0x00 );

                        //> Terminate any running command. Flush_FiFo
                        terminate_and_flush_FiFo();

                        // Clear all IRQ 0,1 flags
                        clear_IRQ();

                        // Write: "Flags" and "Inventory" cmd in FIFO 
                        write_reg( 0x05, 0x36 );
                        write_reg( 0x05, 0x01 );
                        write_reg( 0x05, 0x00 );
                        write_reg( 0x05, 0x00 );

                        // Start tranceive command
                        start_tranceive();

                        //> Wait until the command is finished. Enable IRQ sources.
                        wait_command_and_enable_IRQ();

                            while (w == 0){
                            pc.printf("\nNO CARD DETECTED...\n");
                            pc.printf("WAITING FOR A CARD...\n");
                            
                            led[3] = 0;
                            led[2] = 0;
                            led[0] = 0;
                            led[1] = 1;
                            
                            w++;
                            }

                    } while ( read_reg( 0x40 == 0 ) );

                // Disable IRQ0,IRQ1 interrupt sources 
                disable_IRQ();

                // Read IRQ 0,1 Status register
                read_IRQ_status();

                //> Read FIFO, 0xUID
                r = read_reg( 0x04 );

                pc.printf("\nUID = %02X ",  UID1 = read_reg( 0x05 ));   

                pc.printf("%02X ",  UID2 = read_reg( 0x05 ));

                pc.printf("%02X ",  UID3 = read_reg( 0x05 ));

                pc.printf("%02X ",  UID4 = read_reg( 0x05 ));

                pc.printf("%02X ",  UID5 = read_reg( 0x05 ));

                pc.printf("%02X ",  UID6 = read_reg( 0x05 ));

                pc.printf("%02X ",  UID7 = read_reg( 0x05 ));

                pc.printf("%02X ",  UID8 = read_reg( 0x05 ));

                pc.printf("%02X ",  UID9 = read_reg( 0x05 ));

                pc.printf("%02X\n ",  UID10 = read_reg( 0x05 ));

                // Read IRQ 0,1 Status register
                read_IRQ_status();    

                // Read Error status register
                r = read_reg( 0x0A );    // Response:  00

                r = read_reg( 0x2E );    // Response:  08
                write_reg( 0x2E, 0x08 );
                r = read_reg( 0x0C );    // Response:  80
                r = read_reg( 0x2E );    // Response:  08
                write_reg( 0x2E, 0x08 );
                
                led[3] = 0;
                led[1] = 0;
                led[0] = 0;
                led[2] = 1;

            } while( (read_reg( 0x05 ) & 0x04) == 0 );


        //> =============================================
        //> Apply Waiting time 
        //> =============================================

        write_reg( 0x10, 0x20 );
        write_reg( 0x11, 0xFF );
        write_reg( 0x15, 0x00 );
        write_reg( 0x16, 0x00 );

        r = read_reg( 0x0E );    // Response:  00

        // Clear all IRQ1 flags
        write_reg( 0x07, 0x7F );
        
        led[3] = 0;
        led[0] = 0;
        led[1] = 0;
        led[2] = 1;

    }
}