#include "mbed.h"

SPI spi(p11, p12, p13); // mosi, miso, sclk
DigitalOut cs(p28); // chip select
DigitalOut ifsel1(p26); // interface select pin for  CLRC6630
DigitalOut pdres(p27); // CLRC6630 RESET pin - H = RESET
DigitalOut led[] = {(LED1) , (LED2) , (LED3) , (LED4)}; // onboard LEDs
Serial pc(USBTX, USBRX); // tx, rx

char r;
int w = 0;
//char ATQB0 , ATQB1 , ATQB2 , ATQB3 , ATQB4, ATQB5 , ATQB6 , ATQB7 , ATQB8 , ATQB9, ATQB10 , ATQB11 , ATQB12 , ATQB13 , ATQB14, ATQB15 , ATQB16 , ATQB17 , ATQB18;

 
//write SPI registers    
void write_reg(char n, char o)
{
 
    cs=0; // device select
    
    spi.write (n<<1);
    spi.write (o);
    
    cs=1; // device deselect
 }
 

// read SPI registers
char read_reg(char n)
{
    char t;
    cs=0; // device select
    
    
    spi.write ((n<<1)|0x01);
    t=spi.write (0);
        
    cs=1; // device deselect
    
    return t;
 }
 

//> Terminate any running command. Flush_FiFo
void terminate_and_flush_FiFo()
{
   write_reg( 0x00, 0x00 );
   write_reg( 0x02, 0xB0 );
}


// Clear all IRQ 0,1 flags
void clear_IRQ()
{
   write_reg( 0x06, 0x7F );
   write_reg( 0x07, 0x7F );
} 


// Disable Irq 0,1 sources
void disable_IRQ()
{
   write_reg( 0x08, 0x00 );       
   write_reg( 0x09, 0x00 );
}


//> Wait until the command is finished. Enable IRQ sources.
void wait_command_and_enable_IRQ()
{
   write_reg( 0x08, 0x18 );         // Enable Irqs 0,1
   write_reg( 0x09, 0x42 );         // Enable the global IRQ to be propagated to the IRQ pin
            
   while( (read_reg( 0x07 ) & 0x40)==0);
}


// Read IRQ 0,1 Status register
void read_IRQ_status()
{
   r = read_reg( 0x06 );
   r = read_reg( 0x07 );
}


// Start tranceive command
void start_tranceive()
{
    write_reg( 0x00, 0x07 );
    wait(0.001);
}

 
 int main() {
    
        //  start activity LED;
        led[3] = 0;
        led[2] = 0;
        led[1] = 0;
        led[0] = 1;
                
        // set the comunication method
        //ifsel1 = 0; // usare questa istruzione per le schede revisione prototipo
        ifsel1 = 1; // usare questa istruzione per le schede revisione B
        wait(0.001);
    
        // SPI comunication settings
        spi.format(8,0);
        spi.frequency(1000000);
do {                          
        //RESET the device
        pdres = 1;
        wait(0.001);
        pdres = 0;
    
        wait(0.005);
                
//> Load Protocol
write_reg( 0x0F, 0x98 ); //    Timer0 Timer starts at the end of transmission
write_reg( 0x37, 0xFF );
write_reg( 0x14, 0x92 ); //Timer1 Timer starts at the end of transmission
write_reg( 0x19, 0x20 ); //Timer2
write_reg( 0x1A, 0x03 ); //TReload Hi
write_reg( 0x1B, 0xFF ); //TReload Lo
write_reg( 0x1E, 0x00 ); //Timer3
write_reg( 0x02, 0x90 ); //FIFO control register ->sets FIFO size to 255bytes
write_reg( 0x03, 0xFE ); //Waterlevel settings
write_reg( 0x0C, 0x80 ); //RXBitCtrl (Values AfterColl)
write_reg( 0x28, 0x87 ); //DrvMode_Reg both driver pins enable, invert one driver
write_reg( 0x29, 0xCC ); //00  TXAmp_Reg: set continous wave amplitude, set residual carrier
write_reg( 0x2A, 0x01 ); //DrvCon_Reg: sets driver config to TXEnvelope
write_reg( 0x2B, 0x05 ); //Txl_Reg: sets iiLoad, was auch immer das ist
write_reg( 0x34, 0x00 ); //RxSofD_Reg: Subcarrier and SOF detection off
write_reg( 0x38, 0x12 ); //Rcv_Reg: defines input for signal processing and defines collision level

write_reg( 0x00, 0x00 ); //Idle commmand
wait(0.02);

write_reg( 0x02, 0xB0 ); //FIFO Control

write_reg( 0x06, 0x7F ); //IRQ0_Reg:
write_reg( 0x07, 0x7F ); //IRQ1_Reg:
write_reg( 0x05, 0x04 ); // write Tx and RX protocol numbers (04 for ISO14443B)
write_reg( 0x05, 0x04 ); // write Tx and RX protocol numbers (04 for ISO14443B)
write_reg( 0x08, 0x10 ); //IRQ0En_Reg: IdleIrq is enable propagated to GlobalIRQ
write_reg( 0x09, 0x40 ); //IRQ1En_Reg: GlobalIrq propagated to the interrupt pin
write_reg( 0x00, 0x0D ); //LoadProtocol
wait(0.02);

write_reg( 0x08, 0x00 ); //Reset IRQ0
write_reg( 0x09, 0x00 ); //Reset IRQ1
write_reg( 0x02, 0xB0 ); //FIFO Control 

// Init registers.
write_reg( 0x2C, 0x7B ); 
write_reg( 0x2D, 0x7B ); 
write_reg( 0x2E, 0x08 );
write_reg( 0x2F, 0x0A ); //00 
write_reg( 0x30, 0x00 );
write_reg( 0x31, 0x01 );
write_reg( 0x33, 0x05 ); //05
write_reg( 0x34, 0xB2 );
write_reg( 0x35, 0x34 );
write_reg( 0x37, 0x3F ); //3F
write_reg( 0x38, 0x12 ); // 12
write_reg( 0x39, 0x0A ); //0A 
// End of load protocol

        //  start activity LED;
        led[3] = 0;
        led[2] = 0;
        led[1] = 1;
        led[0] = 0;

//> ==============================================
//> Field Reset
//> ==============================================

// Field off: Read out DrvMod register. Disable Drivers
r = read_reg( 0x28 );   // Response:  87
  
write_reg( 0x47, 0x04 );    // DEBUG
//> phhalHw_FieldOn
write_reg( 0x28, 0x8F );
//SLP 100
wait(0.02);

//> Send REQB command
write_reg( 0x31, 0xC1 );
write_reg( 0x32, 0x0B );
write_reg( 0x00, 0x00 );
write_reg( 0x02, 0xB0 );
write_reg( 0x06, 0x7F );
write_reg( 0x07, 0x7F );

write_reg( 0x05, 0x06 );  // SR176 
write_reg( 0x05, 0x00 );

/*write_reg( 0x05, 0x00 );  // GMTL
write_reg( 0x05, 0x0B );
write_reg( 0x05, 0x3F ); 
write_reg( 0x05, 0x80 ); */

/*write_reg( 0x05, 0x05 ); //ISO14443B
write_reg( 0x05, 0x00 );
write_reg( 0x05, 0x00 );*/

write_reg( 0x00, 0x07 ); // Response:  00

//SLP 100
wait(0.02);

//RE 04 0C    // Read FIFOLevel (12 bytes)
r = read_reg( 0x04 );
//if (r != 0x1B) return;

if( r != 0 )
    {
    //  start activity LED;
    led[3] = 1;
    led[2] = 0;
    led[1] = 0;
    led[0] = 0;
    pc.printf("received = 0x%02X bytes: ",  r);
    while( read_reg( 0x04 ) )
        {
        pc.printf("%02X ", r = read_reg( 0x05 ));
        }
        pc.printf("\r\n",  r);
    }
    else
        pc.printf("NO CARD\r\n");
        
} while( -1 );       
}