#include "mbed.h"

SPI spi(p11, p12, p13); // mosi, miso, sclk
DigitalOut cs(p28); // chip select
DigitalOut ifsel1(p26); // interface select pin for  CLRC6630
DigitalOut pdres(p27); // CLRC6630 RESET pin - H = RESET
DigitalOut led[] = {(LED1) , (LED2) , (LED3) , (LED4)}; // onboard LEDs
Serial pc(USBTX, USBRX); // tx, rx

char r;
int w = 0;
char UID0 , UID1 , UID2 , UID3 , UID4;

 
//write SPI registers    
void write_reg(char n, char o)
{
 
    cs=0; // device select
    
    spi.write (n<<1);
    spi.write (o);
    
    cs=1; // device deselect
 }
 

// read SPI registers
char read_reg(char n)
{
    char t;
    cs=0; // device select
    
    
    spi.write ((n<<1)|0x01);
    t=spi.write (0);
        
    cs=1; // device deselect
    
    return t;
 }
 

//> Terminate any running command. Flush_FiFo
void terminate_and_flush_FiFo()
{
   write_reg( 0x00, 0x00 );
   write_reg( 0x02, 0xb0 );
}


// Clear all IRQ 0,1 flags
void clear_IRQ()
{
   write_reg( 0x06, 0x7f );
   write_reg( 0x07, 0x7f );
} 


// Disable Irq 0,1 sources
void disable_IRQ()
{
   write_reg( 0x08, 0x00 );       
   write_reg( 0x09, 0x00 );
}


//> Wait until the command is finished. Enable IRQ sources.
void wait_command_and_enable_IRQ()
{
   write_reg( 0x08, 0x18 );         // Enable Irqs 0,1
   write_reg( 0x09, 0x42 );         // Enable the global IRQ to be propagated to the IRQ pin
            
   while( (read_reg( 0x07 ) & 0x40)==0);
}


// Read IRQ 0,1 Status register
void read_IRQ_status()
{
   r = read_reg( 0x06 );
   r = read_reg( 0x07 );
}


// Start tranceive command
void start_tranceive()
{
    write_reg( 0x00, 0x07 );
    wait(0.001);
}

 
 int main() {
    
    while (1) {
    
        //  start activity LED;
        led[3] = 0;
        led[2] = 0;
        led[1] = 0;
        led[0] = 1;
                
        // set the comunication method
        //ifsel1 = 0; // usare questa istruzione per le schede revisione prototipo
        ifsel1 = 1; // usare questa istruzione per le schede revisione B
        wait(0.001);
    
        // SPI comunication settings
        spi.format(8,0);
        spi.frequency(1000000);
    
            do {
                              
                w = 0;
    
                    do {
                    
                    wait(0.1);
                    
                    //RESET the device
                    pdres = 1;
                    wait(0.001);
                    pdres = 0;
    
                    wait(0.005);
        
//> =============================================
//> RC663 Script for (Iso14443-3A protocol):
//>   * ReqA
//>   * Get UID (Select: Casade level 1)
//>   * HaltA 
//> 
//> Note: Only one PICC shall be in HF
//> =============================================

//> =============================================
//> RC663 ApplyProtocolSettings:  ISO14443A=01
//> =============================================
//
//> Configure Timers 
//
// Set Timer-0, T0Control_Reg:
// Starts at the end of Tx. Stops after Rx of first data. Auto-reloaded. 13.56 MHz input clock.
   write_reg( 0x0F, 0x98 );    

// Set Timer-1, T1Control_Reg:
// Starts at the end of Tx. Stops after Rx of first data. Input clock - cascaded with Timer-0.
   write_reg( 0x14, 0x92 );
   
// Set Timer-2, T2Control_Reg:  Timer used for LFO trimming
   write_reg( 0x19, 0x20 );
                
// Set Timer-2 reload value (T2ReloadHi_Reg and T2ReloadLo_Reg)
   write_reg( 0x1A, 0x03 );
   write_reg( 0x1B, 0xFF );                            
    
// Set Timer-3, T3Control_Reg:
// Not started automatically. Not reloaded. Input clock 13.56 MHz                
   write_reg( 0x1E, 0x00 );
                            
//> Configure FIFO Size=255 and Water-level
// Set FifoControl_Reg, Fifo size=255 bytes. Flush FIFO
   write_reg( 0x02, 0x90 );            
    
// Set WaterLevel =(FIFO length -1)
   write_reg( 0x03, 0xFE );
                        
// RxBitCtrl_Reg(0x0c)    Received bit after collision are replaced with 1.
   write_reg( 0x0C, 0x80 );
    
// DrvMod reg(0x28), Tx2Inv=1
   r = read_reg( 0x28  );    
   write_reg( 0x28, 0x80 );
                
// TxAmp_Reg(0x29)
   write_reg( 0x29, 0x00 );                
   
// DrvCon_Reg(0x2A)
   write_reg( 0x2A, 0x01 );     
   
// TxI_Reg(0x05),(0x05)
   write_reg( 0x2B, 0x05 );
                
// RxSOFD_Reg(0x34),(0x00), 
   write_reg( 0x34, 0x00 );
    
// Rcv_Reg(0x38),(0x12) 
   write_reg( 0x38, 0x12 );
//
//> =============================================
//> 2. LoadProtocol( bTxProtocol=0, bRxProtocol=0)
//> =============================================

//> Terminate any running command. Flush_FiFo
   terminate_and_flush_FiFo();

// Clear all IRQ 0,1 flags
   clear_IRQ();
   
//> Write in Fifo: Tx and Rx protocol numbers(0,0) 
   r = read_reg( 0x04 );
   write_reg( 0x05, 0x00 );    // Rx protocol=0
   write_reg( 0x05, 0x00 );    // Tx prot=0

// Enable IRQ0 interrupt sources 
// 
// Idle interrupt(Command terminated), RC663_BIT_IDLEIRQ=0x10
   r = read_reg( 0x08 );
   write_reg( 0x08, 0x10 );
         
// Enable Global IRQ propagation.
   r = read_reg( 0x09 );
   write_reg( 0x09, 0x40 );
   wait(0.001);
   r = read_reg( 0x09 );   

//> Start RC663 command "Load Protocol"=0x0d
   write_reg( 0x00, 0x0D );

//L_LoadProtocol

   while( (read_reg( 0x07 ) & 0x40)==0);
   
// Disable Irq 0,1 sources
   disable_IRQ();

//> Flush Fifo. Read Error Reg
   write_reg( 0x02, 0xB0 );
   r = read_reg( 0x0A );

// Apply RegisterSet
//
//> Configure CRC-16 calculation, preset value(0x6363) for Tx&Rx
   write_reg( 0x2C, 0x18 );
   write_reg( 0x2D, 0x18 );
   write_reg( 0x2E, 0x08  );

// Length of the pulse modulation in carrier clks+1  
   write_reg( 0x2F, 0x20 );
   
// Symbol 1 and 0 burst lengths = 8 bits.
   write_reg( 0x30, 0x00 );
   
// Start symbol=Symbol2, Stop symbol=Symbol3
   write_reg( 0x33, 0xCF );
 
// Set Rx Baudrate 106 kBaud    
   write_reg( 0x35, 0x04 );
  
// Set min-levels for Rx and phase shift   
   write_reg( 0x37, 0x32 );
   write_reg( 0x39, 0x00 );
                 
// Set Rx waiting time  
   write_reg( 0x36, 0x90 );
   write_reg( 0x31, 0xC0 );
   write_reg( 0x32, 0x0B );

// Set Timeout. Write T0,T1 reload values(hi,Low)
   write_reg( 0x10, 0x08 );
   write_reg( 0x11, 0xD8 );
   write_reg( 0x15, 0x00 );
   write_reg( 0x16, 0x00 );
   
// Write DrvMod register   
   write_reg( 0x28, 0x81 );
   
//> MIFARE Crypto1 state is further disabled.
   write_reg( 0x0B, 0x00 );

//>  FieldOn
   write_reg( 0x28, 0x89 );
   
   wait(0.005);
   
//> =============================================
//>  I14443p3a_Sw_RequestA
//> =============================================
   
//  TxWaitStart at the end of Rx data
   write_reg( 0x31, 0xC0 );
   
// Set min.time between Rx and Tx or between two Tx   
   write_reg( 0x32, 0x0B );
         
//> Set timeout for this command cmd. Init reload values for timers-0,1 
   write_reg( 0x10, 0x08 );
   write_reg( 0x11, 0x94 );
   write_reg( 0x15, 0x00 );           
   write_reg( 0x16, 0x00 );
   write_reg( 0x06, 0x08 );
   write_reg( 0x36, 0x90 );
   write_reg( 0x2E, 0x0F );    

//> ---------------------
//> Send the ReqA command  
//> ---------------------

//> Terminate any running command. FlushFifo
   terminate_and_flush_FiFo();      

// Clear all IRQ 0,1 flags 
   clear_IRQ();

//> Write ReqA=26 into FIFO
   write_reg( 0x05, 0x26 );    

//> Start RC663 command "Transcieve"=0x07. Activate Rx after Tx finishes.
   write_reg( 0x00, 0x07 );
   
//> Wait until the command is finished. Enable IRQ sources.
   wait_command_and_enable_IRQ();
   
// Disable Irq 0,1 sources
   disable_IRQ();       
   
// Return Irq0 status    
   r = read_reg( 0x06 );   

//> Wait until reception
   write_reg( 0x08, 0x54 );
   write_reg( 0x09, 0x42 );
   wait(0.001);
   
   while( (read_reg( 0x07 ) & 0x40)==0);
   
   while (w == 0){
   pc.printf("\nNO CARD DETECTED...\n");
   pc.printf("WAITING FOR A CARD...\n");
   w++;
   }
   
   } while ( read_reg( 0x40 == 0 ) );
   
   write_reg( 0x08, 0x00 );
   write_reg( 0x09, 0x00 );
      
   r = read_reg( 0x05 );     
   r = read_reg( 0x05 );    
               
// Read the error register            
   r = read_reg( 0x0a );            

// Reset TxLastBits_Reg
   write_reg( 0x2E, 0x08 );

//> ------------------------------
//> Get UID cascade level-1
//> ------------------------------               
   write_reg( 0x2E, 0x08 );
   write_reg( 0x0C, 0x00 );

// Terminate any running command, FlushFifo
   terminate_and_flush_FiFo();

// Clear all IRQ 0,1 flags 
    clear_IRQ();
      
//> Write "Antcollision CL 1" cmd into FIFO (SEL=93, NVB=20)
    write_reg( 0x05, 0x93 );
    write_reg( 0x05, 0x20 );
      
// Start tranceive command
   start_tranceive();
    
// Wait until the command is finished 
   wait_command_and_enable_IRQ();
    
// Disable IRQ0 interrupt sources
   disable_IRQ();
          
// Read IRQ 0,1 Status register        
   read_IRQ_status();    
  
//> Read FIFO, Expected - Complete UID (one PICC in HF)
    r = read_reg( 0x04 );            // FIFO length
   
    // Cascade Tag (UID0)
    pc.printf("\nUID = 0x%02X",  UID0 = read_reg( 0x05 ));
        
    // UID1
    pc.printf("%02X",  UID1 = read_reg( 0x05 ));
        
    // UID2
    pc.printf("%02X",  UID2 =read_reg( 0x05 ));
        
    // UID3
    pc.printf("%02X\n",  UID3 =read_reg( 0x05 ));
       
    // BCC
    pc.printf("BCC = 0x%02X\n",  UID4 =read_reg( 0x05 ));
       
    led[1] = 1;
    
    w = 1;

//> Read Error register       
    r = read_reg( 0x0A );
    
//> ------------------------------
//> Select cascade level-1
//> ------------------------------               
// Terminate any running command, FlushFifo
   terminate_and_flush_FiFo();
   
   write_reg( 0x2C, 0x19 );          // Enable RX and TX CRC
   write_reg( 0x2D, 0x19 ); 
   write_reg( 0x0C, 0x00 ); 


// Clear all IRQ 0,1 flags 
   clear_IRQ();
      
//> Write "Select CL 1" cmd into FIFO (SEL=93, NVB=70)
   write_reg( 0x05, 0x93 );
   write_reg( 0x05, 0x70 );
   write_reg( 0x05, UID0 );          // UID bytes ...
   write_reg( 0x05, UID1 );
   write_reg( 0x05, UID2 );
   write_reg( 0x05, UID3 );
   write_reg( 0x05, UID4 );
      
// Start tranceive command 
   start_tranceive();

// Wait until the command is finished 
   wait_command_and_enable_IRQ();
      
// Disable IRQ0 interrupt sources
   disable_IRQ();
          
// Read IRQ 0,1 Status register        
   read_IRQ_status();
      
//> Read FIFO, Expected - Complete UID (one PICC in HF)
   r = read_reg( 0x04 );             // FIFO length
   
   } while( (read_reg( 0x05 ) & 0x04) == 0 );

   pc.printf("7 BYTE CARD DETECTED\n");
   
   led[2] = 1;
   
//----------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------
//> ------------------------------
//> Get UID cascade level-2
//> ------------------------------               
   write_reg( 0x2E, 0x08 );
   write_reg( 0x0C, 0x00 );
   write_reg( 0x2C, 0x18 );       // TX, RX CRC off
   write_reg( 0x2D, 0x18 ); 

// Terminate any running command, FlushFifo
   terminate_and_flush_FiFo();

// Clear all IRQ 0,1 flags 
   clear_IRQ();
      
//> Write "Antcollision CL 2" cmd into FIFO (SEL=95, NVB=20)
   write_reg( 0x05, 0x95 );
   write_reg( 0x05, 0x20 );
      
// Start tranceive command 
   start_tranceive();   

// Wait until the command is finished 
   wait_command_and_enable_IRQ();   
   
// Disable IRQ0 interrupt sources
   disable_IRQ();
          
// Read IRQ 0,1 Status register        
   read_IRQ_status();    
  
//> Read FIFO
   r = read_reg( 0x04 );             // FIFO length
   
   // Cascade Tag (UID0)
    pc.printf("UID = 0x%02X",  UID0 = read_reg( 0x05 ));
        
    // UID1
    pc.printf("%02X",  UID1 = read_reg( 0x05 ));   
    
    // UID2
    pc.printf("%02X",  UID2 =read_reg( 0x05 ));   
    
    // UID
    pc.printf("%02X\n",  UID3 =read_reg( 0x05 ));   
    
    // BCC
    pc.printf("BCC = 0x%02X\n",  UID4 =read_reg( 0x05 ));
    
    led[3] = 1;

//> Read Error register       
   r = read_reg( 0x0A );   

//> ------------------------------
//> Select cascade level-2
//> ------------------------------               
// Terminate any running command, FlushFifo
   terminate_and_flush_FiFo();
   
   write_reg( 0x2C, 0x19 );          // Enable RX and TX CRC
   write_reg( 0x2D, 0x19 ); 
   write_reg( 0x0C, 0x00 ); 

// Clear all IRQ 0,1 flags 
   clear_IRQ();
      
//> Write "Select CL 2" cmd into FIFO (SEL=95, NVB=70)
   write_reg( 0x05, 0x95 );
   write_reg( 0x05, 0x70 );
   write_reg( 0x05, UID0 );          // UID bytes ...
   write_reg( 0x05, UID1 );
   write_reg( 0x05, UID2 );
   write_reg( 0x05, UID3 );
   write_reg( 0x05, UID4 );
      
// Start tranceive command 
   start_tranceive();

// Wait until the command is finished 
   wait_command_and_enable_IRQ();
      
// Disable IRQ0 interrupt sources
   disable_IRQ();
          
// Read IRQ 0,1 Status register
   read_IRQ_status();
  
//> Read FIFO
   r = read_reg( 0x04 );              // FIFO length
   
   r = read_reg( 0x05 );              // Response
  
   led[3] = 1 ;

    }
}