/* 
Serial Communication with a PC
The mbed Microcontroller can communicate with a host PC through a "USB Virtual Serial Port" 
over the same USB cable that is used for programming.
This enables you to:
a) Print out messages to a host PC terminal (useful for debugging!)
b) Read input from the host PC keyboard
c) Communicate with applications and programming languages running on the host PC 
   that can communicate with a serial port, e.g. perl, python, java, c# and so on.
.. see http://mbed.org/handbook/SerialPC 

The C stdin, stdout and stderr file handles are also defaulted to the PC serial connection
standard calls are: printf, scanf, getc, putc, ..
*/

#include "mbed.h"
// global vars and objects
BusOut doLeds(LED1,LED2,LED3,LED4);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
InterruptIn diUp(p15);
Timer timer1;
Serial pc(USBTX, USBRX); // tx, rx    ; is default !!! (9600, 8N1)
char recChar=0;
bool recFlag=false;
char recArr[20];
int index=0;

// functions
void flushSerialBuffer() { 
    while (pc.readable()) { 
        pc.getc(); 
    } 
}
    
void readData() {
    recChar = pc.getc();
    recArr[index] = recChar;
    index++;
    
        recFlag = true;
        recArr[index] = 0;
        index = 0;
        pc.printf(" - That's the input: %s\r\n", recArr);  
        
        if(recArr[0]=='a')
        {
            doLeds = 0;
            }
        else if(recArr[0]=='e')
        {
            doLeds = 15;
            }
        else if(recArr[0]=='A')
        {
            doLeds = 0;
            }
        else if(recArr[0]=='E')
        {
            doLeds = 15;
            }
        else if(recArr[0]=='t')
        {
            doLeds = !doLeds;
            }
            
            
       else
       {
         pc.printf("Eingabe inkorrekt!"); 
         flushSerialBuffer();
         while(1)
         {   timer1.start();
            if(timer1.read_ms()>=100)
             {doLeds = !doLeds;
             timer1.reset();}
           
             
             }
        }
        
  
        
        
        flushSerialBuffer();
        
    
}

      void Up()
{
    doLeds = 9;
    return;
    }
    
int main() {
    diUp.rise(&Up);
//    pc.baud(115200);
    pc.baud(38400);
    pc.format(8, SerialBase::Odd, 2);
    doLeds = 0;
    

    flushSerialBuffer();
    pc.printf("Hatzl Andreas: Gruppe A\r\n Bitte geben Sie einen Befehl ein:\r\n");
    pc.attach(&readData);
    
    while(1) {
        if (recFlag) {
            flushSerialBuffer();
//            pc.printf(" - That's the input: %s\r\n", recArr);  // non reantrant function
            recFlag = false;
            
        }
    }
}
