#include "mbed.h"
 
DigitalOut myled(LED1);
InterruptIn sensor(PTB10);
 
Serial pc(USBTX, USBRX);
 
int NbTopsFan;
int Calc;
 
void rpm()     //This function increments on the rising edge of the hall effect sensors signal
{ 
  NbTopsFan++;  
} 
 
int main() {
    
    while(1) {
        
        NbTopsFan = 0;                  //Set NbTops to 0 ready for calculations
        myled=1;
        sensor.rise(&rpm);              //Enables rising edge interrupt
        wait_ms(1000);                  //Wait 1 second and count HALL pulses
        sensor.rise(NULL);              //Disable interrupt
        myled=0;
        
        Calc = (NbTopsFan * 60) / 7.5;  //(Pulse frequency x 60) / 7.5Q, = flow rate in L/hour 
        
        pc.printf ("Flow L/hour: %d\r\n",Calc);  //Prints the number calculated above        
    }
}