#include "mbed.h"
#include "C12832.h"
#include "Sht31.h"

/* Sets up LCD and prints sensor data value of temperature sensor to LCD */

C12832 lcd(PE_14, PE_12, PD_12, PD_11, PE_9); //LCD: MOSI, SCK, RESET, A0, nCS
Sht31 sht31(PF_0, PF_1); //TEMP SENSOR: I2C_SDA, I2C_SCL

int main()
{
    while(1) {
        float t = sht31.readTemperature();
        float h = sht31.readHumidity();
        
        lcd.locate(0,3);
        lcd.printf("[TEMP/HUM]");
        lcd.locate(0,15);
        lcd.printf("TEMP:%3.2fC, HUM:%3.2f%%", t, h); // Print to LCD values
    }
}
