#include "mbed.h"
#include "C12832.h"
#include "TSL2561.h"

/* Sets up LCD and prints sensor data value of Indoor Air Quality sensor to LCD */

C12832 lcd(PE_14, PE_12, PD_12, PD_11, PE_9); //LCD: MOSI, SCK, RESET, A0, nCS
TSL2561 tsl2561(PF_0, PF_1, TSL2561_ADDR_HIGH); //LIGHT SENSOR: I2C_SDA, I2C_SCL 

int main()
{
    tsl2561.begin();
    tsl2561.setGain(TSL2561_GAIN_0X);
    tsl2561.setTiming(TSL2561_INTEGRATIONTIME_402MS);

    while(1) {
        int x = tsl2561.getLuminosity(TSL2561_VISIBLE);
        int z = tsl2561.getLuminosity(TSL2561_INFRARED);
           
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("[LIGHT]");
        lcd.locate(0,14);
        lcd.printf("VIS: %d, INFR: %d ",x, z);
        wait(1); // Print to LCD values
    }
}