#include "mbed.h"
#include "C12832.h"
#include "CCS811.h"

/* Sets up LCD and prints sensor data value of Indoor Air Quality sensor to LCD */

C12832 lcd(PE_14, PE_12, PD_12, PD_11, PE_9); //LCD: MOSI, SCK, RESET, A0, nCS
CCS811 ccs811(PF_0, PF_1); //IAQ SENSOR: I2C_SDA, I2C_SCL

int main()
{
    ccs811.init();
    
    while(1) {
        uint16_t eco2, tvoc;
        ccs811.readData(&eco2, &tvoc);
        
        lcd.locate(0,3);
        lcd.printf("[AIR QUAL]");
        lcd.locate(0,15);
        lcd.printf("eCO2:%dppm, TVO:%dppb", eco2, tvoc); // Print to LCD values
        wait(1);
        lcd.cls();
    }
}