/*
    Height_Sensor.cpp - MB1033 HRLV-MaxSonar®-EZ3 sensor library
    Developed by Andrea Corrado   
*/


#include "mbed.h"
#include "sonar.h"
    


MAXBOTIX::MAXBOTIX(PinName ain, PinName intr):_ain(ain), _intr(intr){
calibration(); //Neccessary to run, 
}
    
float MAXBOTIX::calibration() 
{

        Raw=_ain.read()*5120/1000; //Convert from AnalogueIn to measumrent in meters
        Zero=Raw; //Current read value to Zero
        return Zero; //Returns zero value to use as refrence to all other measurements to obtain absolute height
}

float MAXBOTIX::data_conversion_m()
{
        Raw=_ain.read()*5120/1000;
        return Absolute=Zero-Raw; //Find distance of object from Zero location
    }
    
float MAXBOTIX::data_conversion_inch()
{
        Raw=_ain.read()*5120/1000*2.54;
        return Absolute=Zero-Raw; //Find distance of object from Zero location
    }


    
    
