/*
    Height_Sensor.cpp - MB1033 HRLV-MaxSonar®-EZ3 sensor library
    Developed by Andrea Corrado   
*/

/*
    Example 'main.cpp'

DigitalOut myled(LED1);
Serial pc (USBTX, USBRX);

MAXBOTIX ez2(PTB3, SW2);

float var=0;

int main()
{
    while(1) {

        var=ez2.height_detect();
        if (var!=0)
            pc.printf("\n\r Result %f ", var);
    }
}

*/

#ifndef MBED_HEIGHT_H
#define MBED_HEIGHT_H

#include "mbed.h"



class MAXBOTIX {
    
public:

    MAXBOTIX (PinName ain, PinName intr); //(AnalogueIn, SW2), SW2 usable for set/reset zero if needed.
    
    float calibration(); //As soon as device turns on, height reading is taken to get zero refrence, make sure nothing obstructs sensor when turn on, 300mm radius, reset to obtain new zero.
    
    float data_conversion_inch(); //Convert analogue voltage to Absolute measurement in inches 
    
    float data_conversion_m(); //Convert analogue voltage to Absolute measurement in meters 

protected:
    AnalogIn _ain;
    InterruptIn _intr;
    float Raw;
    float Zero;
    float Absolute;    
};

#endif