#include "mbed.h"
//#include "Hammer_MicrophoneSensor.h"
Serial pc (USBTX, USBRX);




class MAX9814 {
    
public:

    MAX9814(PinName pin): _pin(pin), _led1(LED1), _led2(LED2), _led3(LED3), _led4(LED4) {
    }


void led_array(float x ) {

    if (_value<x+0.05) {
            _led1=0;
            _led2=0;
            _led3=0;
            _led4=0;
    }
    if (_value>x+0.05&&_value<0.5+x) {
            _led1=1;
            _led2=0;
            _led3=0;
            _led4=0;
    }
    if (_value>0.5+x&&_value<1+x) {
            _led1=1;
            _led2=1;
            _led3=0;
            _led4=0;
    }
    if (_value>1+x&&_value<1.2+x) {
            _led1=1;
            _led2=1;
            _led3=1;
            _led4=0;
    }
    if (_value>1.2+x&&_value<2.8+x) {
            _led1=1;
            _led2=1;
            _led3=1;
            _led4=1;
    }
}

float calibration() {
    
    _t.start();
    _t1.start();
    float peakToPeak=0, signalMax=0, signalMin=1024;

    while (_t1.read()<1) {
        while (_t.read_ms()<50) {
            _sample=_pin.read();

            if (_sample<1024) {
                if (_sample>signalMax)
                    signalMax=_sample;

                else if (_sample<signalMin)
                    signalMin=_sample;
            }
        }
     _t.reset();
     peakToPeak=signalMax-signalMin;
     _value= (peakToPeak*3.3);
     _value = floor(_value * 100) / 100;
     _sum+=_value;
     _count++;
    }
    _average=_sum/_count;
    _t1.reset();

    return _average;
}

float sound_level() {

    _t.start();
    float peakToPeak=0, signalMax=0, signalMin=1024;

    while (_t.read_ms()<50) {
        _sample=_pin.read();

        if (_sample<1024) {
            if (_sample>signalMax)
                signalMax=_sample;

            else if (_sample<signalMin)
                signalMin=_sample;
        }
    }
    _t.reset();
    peakToPeak=signalMax-signalMin;
    _value= (peakToPeak*3.3);
    _value = floor(_value * 100) / 100;
    _sum+=_value;
    _count++;

    return _value;
}


void volume_indicator() {
        led_array(_average);
        sound_level();
}

protected:
    AnalogIn _pin;
    BusOut _led1, _led2, _led3, _led4;
    float _value,_sum,_average;
    int _count;
    float _sample;
    Timer _t,_t1;

};




MAX9814 mic(p20);

int main()
{
    mic.calibration();
    while (1) {
        mic.volume_indicator();
        mic.sound_level();
        pc.printf("\n\r Level is %f", mic.sound_level());
    }
}