//Credit to Paul Staron. https://os.mbed.com/questions/6129/I2C-Not-Working/

#include "mbed.h"

#define I2C_SDA PF_0
#define I2C_SCL PF_1
 
Serial pc(USBTX, USBRX);
 
I2C i2c(I2C_SDA, I2C_SCL); // I2C device sda, scl
 
 
int main() {
    i2c.frequency(10000); // set required i2c frequency
    
    pc.printf("I2C Searching!\n\n");
    pc.printf("Starting....\n\n");    
    
    while (1) {
        int count = 0;
        for (int address=0; address<256; address+=2) {
            if (!i2c.write(address, NULL, 0)) { // 0 returned is ok                
                pc.printf("I2C address 0x%02X\n", address);
                count++;
            }
        }        
        pc.printf("%d devices found\n\n\n", count);
        wait(2);       
    }
}