#include "mbed.h"

I2C i2c(PTE25, PTE24);
Serial pc(USBTX, USBRX);
int address = 0xA2;
int pointerAdddress = 0;
char s[64];

// function declaration
void writeEEPROM(int address, unsigned int eeaddress, char *data, int size);
void readEEPROM(int address, unsigned int eeaddress, char *data, int size);

// this function has 63 bytes write limit
void writeEEPROM(int address, unsigned int eeaddress, char *data, int size)
{
    char i2cBuffer[size + 2];
    i2cBuffer[0] = (unsigned char)(eeaddress >> 8); // MSB
    i2cBuffer[1] = (unsigned char)(eeaddress & 0xFF); // LSB

    for (int i = 0; i < size; i++) {
        i2cBuffer[i + 2] = data[i];
    }

    int result = i2c.write(address, i2cBuffer, size + 2, false);
    wait_ms(6);
}

// this function has no read limit
void readEEPROM(int address, unsigned int eeaddress, char *data, int size)
{
    char i2cBuffer[2];
    i2cBuffer[0] = (unsigned char)(eeaddress >> 8); // MSB
    i2cBuffer[1] = (unsigned char)(eeaddress & 0xFF); // LSB

    // Reset eeprom pointer address
    int result = i2c.write(address, i2cBuffer, 2, false);
    wait_ms(6);

    // Read eeprom
    i2c.read(address, data, size);
    wait_ms(6);
}

int main()
{
    char data_read[64];
    readEEPROM(address, pointerAdddress, data_read, 64);
    pc.printf("Previous data stored: %s\n", data_read);
    while(1){
        
    pc.gets(s,64);
    char writeDataLen = 0;
    do {writeDataLen++;} while (s[writeDataLen]); // calculate the text length
    
    writeEEPROM(address, pointerAdddress, s, writeDataLen);
    pc.printf("Data written: %s\n", s);
    
    // read the data back
    char data_read[writeDataLen];
    readEEPROM(address, pointerAdddress, data_read, writeDataLen);
    pc.printf("Data read: %s\n", data_read);
    }

}








