#include "mbed.h"
#include "DebouncedIn.h"
#include "TextLCD.h"
#include "QEI.h"
#include "Rtc_Ds1307.h"
 
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5, TextLCD::LCD20x4); // rs, e, d4-d7 Teclado
Rtc_Ds1307 rtc(PTE0, PTE1);//SCL,SDA
QEI wheel (PTA13, PTD5, NC, 624, QEI::X4_ENCODING);
Serial pc(USBTX, USBRX, "pc");
DebouncedIn b_en(PTC16);

 
DigitalOut red(LED_RED);
DigitalOut green(LED_GREEN);
DigitalOut blue(LED_BLUE);

PwmOut Sonido(PTA5);
 
float periodo;
float Frecuencia=4000;
int C1=0x0C;
int m,k,x1,x2,x3,x4;
int numero=1;
int Conf=0;  // 0: Alarma y 1:Reloj
int Lugar=0; // Definen el punto en el cual va el programa
int i=0;
int visual=0;
int alarma=0; 
int a = 0;
 
int main()
{
    Rtc_Ds1307::Time_rtc t = {};
    Rtc_Ds1307::Time_rtc Hora = {};
    Rtc_Ds1307::Time_rtc Alm = {};
    Rtc_Ds1307::Time_rtc Alm2 = {};
    Rtc_Ds1307::Time_rtc Alm3 = {};
    Rtc_Ds1307::Time_rtc Alm4 = {};
    Rtc_Ds1307::Time_rtc Alm_d = {};
    Rtc_Ds1307::Time_rtc Alm2_d = {};
    Rtc_Ds1307::Time_rtc Alm3_d = {};
    Rtc_Ds1307::Time_rtc Alm4_d = {};
    lcd.cls();
    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD
       
    periodo=(1/Frecuencia);
    Sonido.period(periodo);
    
    rtc.getTime(Hora);
    rtc.stopClock(); 
    while(1){
        menu:
        switch (Lugar){

            case 0:     //Menu principal
                lcd.cls();
                rtc.getTime(Hora); //lee el tiempo del DS1307 
                lcd.locate(0,0);
                lcd.printf("%02d:%02d %02d/%02d/%02d", Hora.hour, Hora.min, Hora.date, Hora.mon, Hora.year);
                lcd.locate(0,1);
                lcd.printf("-Cambiar Hora");
                lcd.locate(0,2);
                lcd.printf("-Cambiar Alarma");
                lcd.locate(0,3);
                lcd.printf("-Visualizar");
                m=wheel.getPulses();  // m son los datos del encoder
                if(m!=0 && Conf==0){
                    Conf=1;
                    wheel.reset();  
                    m=0;              
                }
                if(m!=0 && Conf==1){
                    Conf=2;
                    wheel.reset();  
                    m=0;              
                }
                
                if(m!=0 && Conf==2){
                    Conf=0;
                    wheel.reset();  
                    m=0;              
                }
                if(Conf==0){
                    lcd.locate(0,1);
                    lcd.printf(">");                    
                    lcd.locate(0,2);
                    lcd.printf("-");
                    lcd.locate(0,3);
                    lcd.printf("-");
                    //lcd.locate(0,1);                    
                    wait(0.1);
                }
                if(Conf==1){
                    lcd.locate(0,1);
                    lcd.printf("-");                    
                    lcd.locate(0,2);
                    lcd.printf(">");
                    lcd.locate(0,3);
                    lcd.printf("-");                    
                    //lcd.locate(0,1);                    
                    wait(0.1);
                }
 
                if(Conf==2){
                    lcd.locate(0,1);
                    lcd.printf("-");                    
                    lcd.locate(0,2);
                    lcd.printf("-");
                    lcd.locate(0,3);
                    lcd.printf(">");                    
                    //lcd.locate(0,1);                    
                    wait(0.1);
                }               
                if (b_en.falling()){  //si se pulsa boton encoder
                    if(Conf == 0){ 
                    Lugar++;
                    }
                    if(Conf == 1){ 
                    Lugar++;
                    }
                    if(Conf == 2){ 
                    Lugar=3;
                    }
                    m=0;       
                }
            break;
    
            case 1://Configurar
                       if(Conf==0){
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Configurar Hora ");
                           goto hora;                               
                        }
                        
                       if(Conf==1){
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Configurar Alarma");
                            goto alarm;
                        }
                        if(Conf==2){
                            Lugar=3;
                        }     
    case 2:
    goto desactivar;
 
    case 3:     //Visualizar y Activacion Alarmas
        rtc.getTime(Hora);
        m=wheel.getPulses();
        if(x1==1){
            red=1;
        }
        if(x2==1){
            green=1;
        }
        if(x3==1){
            blue=1;
        }
        if(x4==1){
            red=1;
        }                
        if(m!=0){
            visual=visual+m;
            if(visual<0){
                visual=0;
            }
            if(visual>4){
                visual=4;
            }                    
            wheel.reset();  
            m=0;
        }
                
        if(visual==0){//Visualiza hora
            lcd.cls();
            lcd.locate(0,0);    
            lcd.printf(" Ver   %02d:%02d:%02d",Hora.hour,Hora.min,Hora.sec);
            lcd.locate(0,1);
            lcd.printf("Hora :%02d/%02d/%04d",Hora.date,Hora.mon,Hora.year);
            wait(0.1);
        }   
        if(visual==1){//Visualilza alarma1
            lcd.cls();
            lcd.locate(0,0);    
            lcd.printf(" Ver   %02d:%02d:%02d",Alm.hour, Alm.min,Alm.sec);
            lcd.locate(0,1);
            lcd.printf("Alar1: %02d/%02d/%04d",Alm.date,Alm.mon,Alm.year);
            lcd.locate(0,2);    
            lcd.printf("Desact:%02d:%02d:%02d",Alm_d.hour, Alm_d.min,Alm_d.sec);
            lcd.locate(0,3);
            lcd.printf("Alar1: %02d/%02d/%04d",Alm_d.date,Alm_d.mon,Alm_d.year);
            wait(0.1);
        }
        if(visual==2){//Visualiza alarma2
            lcd.cls();
            lcd.locate(0,0);    
            lcd.printf(" Ver   %02d:%02d:%02d",Alm2.hour, Alm2.min,Alm2.sec);
            lcd.locate(0,1);
            lcd.printf("Alar2: %02d/%02d/%04d",Alm2.date,Alm2.mon,Alm2.year);
            lcd.locate(0,2);    
            lcd.printf("Desact %02d:%02d:%02d",Alm2_d.hour, Alm2_d.min,Alm2_d.sec);
            lcd.locate(0,3);
            lcd.printf("Alar2: %02d/%02d/%04d",Alm2_d.date,Alm2_d.mon,Alm2_d.year);
            wait(0.1);
        }
        if(visual==3){//Visualiza alarma3
            lcd.cls();
            lcd.locate(0,0);    
            lcd.printf(" Ver   %02d:%02d:%02d",Alm3.hour, Alm3.min,Alm3.sec);
            lcd.locate(0,1);
            lcd.printf("Alar3: %02d/%02d/%04d",Alm3.date,Alm3.mon,Alm3.year);
            lcd.locate(0,2);    
            lcd.printf("Desact: %02d:%02d:%02d",Alm3_d.hour, Alm3_d.min,Alm3_d.sec);
            lcd.locate(0,3);
            lcd.printf("Alar3: %02d/%02d/%04d",Alm3_d.date,Alm3_d.mon,Alm3_d.year);
            wait(0.1);
            
        }
        if(visual==4){//Visualiza alarma4
            lcd.cls();
            lcd.locate(0,0);    
            lcd.printf(" Ver    %02d:%02d:%02d",Alm4.hour, Alm4.min,Alm4.sec);
            lcd.locate(0,1);
            lcd.printf("Alar4:  %02d/%02d/%04d",Alm4.date,Alm4.mon,Alm4.year);
            lcd.locate(0,2);    
            lcd.printf("Desact: %02d:%02d:%02d",Alm4_d.hour, Alm4_d.min,Alm4_d.sec);
            lcd.locate(0,3);
            lcd.printf("Alar4:  %02d/%02d/%04d",Alm4_d.date,Alm4_d.mon,Alm4_d.year);
            wait(0.1);
        }
                     
        if (b_en.falling()){
            lcd.cls();
            Lugar=0;
        }
                //Activacion  Alarma1               
        if((Hora.date==Alm.date)&&(Hora.mon==Alm.mon)&&(Hora.year==Alm.year)&&(Hora.hour==Alm.hour)&&(Hora.min==Alm.min)&&(Hora.sec==Alm.sec))
        {
                    lcd.cls();
                    lcd.locate(0,0);                        
                    lcd.printf("Alarma 1  Activa!!");
                    red =0;
                    wait(.2);
                    red =1;
                    wait(.2);
                    red =0;
                    wait(.2);
                    red =1;
                    wait(.2);
                    red =0;
                    lcd.locate(0,0);
                    lcd.printf("Esperando Desactivacion");
                    wait(1);                       
                    m=0;
                    k=1;
                    alarma = 1;
                    goto menu;
                }
 
                //Activacion  Alarma2               
                if((Hora.date==Alm2.date)&&(Hora.mon==Alm2.mon)&&(Hora.year==Alm2.year)&&(Hora.hour==Alm2.hour)&&(Hora.min==Alm2.min)&&(Hora.sec==Alm2.sec))
                {
                    lcd.cls();
                    lcd.locate(0,0);                        
                    lcd.printf("Alarma 2  Activa!!");
                    green =0;
                    wait(.2);
                    green =1;
                    wait(.2);
                    green =0;
                    wait(.2);
                    green =1;
                    wait(.2);
                    green =0;
                    lcd.locate(0,0);
                    lcd.printf("Esperando desactivacion");
                    wait(1);
                    Lugar = 3;                       
                    m=0;
                    k=2;
                    alarma = 1;
                    goto menu;
                }
 
                //Activacion  Alarma3               
                if((Hora.date==Alm3.date)&&(Hora.mon==Alm3.mon)&&(Hora.year==Alm3.year)&&(Hora.hour==Alm3.hour)&&(Hora.min==Alm3.min)&&(Hora.sec==Alm3.sec))
                {
                    lcd.cls();
                    lcd.locate(0,0);                        
                    lcd.printf("Alarma 3  Activa!!");
                    blue =0;
                    wait(.2);
                    blue =1;
                    wait(.2);
                    blue =0;
                    wait(.2);
                    blue =1;
                    wait(.2);
                    blue =0;
                    lcd.locate(0,0);
                    lcd.printf("Esperando desactivacion");
                    wait(1);
                    lcd.locate(0,1);             
                    m=0;
                    k=3;
                    alarma = 1;
                    goto menu;
                }
                //Activacion  Alarma4               
                if((Hora.date==Alm4.date)&&(Hora.mon==Alm4.mon)&&(Hora.year==Alm4.year)&&(Hora.hour==Alm4.hour)&&(Hora.min==Alm4.min)&&(Hora.sec==Alm4.sec))
                {
                    lcd.cls();
                    lcd.locate(0,0);                        
                    lcd.printf("Alarma 4  Activa!!");
                    red =0;
                    wait(.2);
                    red =1;
                    wait(.2);
                    red =0;
                    wait(.2);
                    red =1;
                    wait(.2);
                    red =0;
                    lcd.locate(0,0);
                    lcd.printf("Esperando desactivacion");
                    wait(1);                     
                    m=0;
                    alarma =1;
                    k=4;
                }
                 
            //Desactivar Alarma
                
                if(alarma==1){
                    Sonido.write(0.5);
                    red = 0;
                    wait(0.2);
                    red = 1;
                    Sonido.write(0);
                    wait(0.2);
                    blue = 0;
                    Sonido.write(0.5);
                    wait(0.2);
                    blue = 1;
                    Sonido.write(0);
                    wait(0.2);
                }
                //Desactivacion  Alarma1               
        if((Hora.date==Alm_d.date)&&(Hora.mon==Alm_d.mon)&&(Hora.year==Alm_d.year)&&(Hora.hour==Alm_d.hour)&&(Hora.min==Alm_d.min)&&(Hora.sec==Alm_d.sec))
        {
                    lcd.cls();
                    lcd.locate(0,0);                        
                    lcd.printf("Alarma 1 Desactivada");
                    wait(1);
                    red =0;
                    wait(.2);
                    red =1;
                    wait(.2);
                    red =0;
                    wait(.2);
                    red =1;
                    wait(.2);
                    red =0;
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Adios");
                    alarma = 0;
                    wait(1);                       
                    m=0;
                    k=1;
                }
 
                //Desactivacion  Alarma2               
                if((Hora.date==Alm2_d.date)&&(Hora.mon==Alm2_d.mon)&&(Hora.year==Alm2_d.year)&&(Hora.hour==Alm2_d.hour)&&(Hora.min==Alm2_d.min)&&(Hora.sec==Alm2_d.sec))
                {
                    lcd.cls();
                    lcd.locate(0,0);                        
                    lcd.printf("Alarma 2  Desactivada");
                    wait(1);
                    green =0;
                    wait(.2);
                    green =1;
                    wait(.2);
                    green =0;
                    wait(.2);
                    green =1;
                    wait(.2);
                    green =0;
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Adios");
                    alarma = 0; 
                    wait(1);                      
                    m=0;
                    k=2;
                }
 
                //Desactivacion  Alarma3               
                if((Hora.date==Alm3_d.date)&&(Hora.mon==Alm3_d.mon)&&(Hora.year==Alm3_d.year)&&(Hora.hour==Alm3_d.hour)&&(Hora.min==Alm3_d.min)&&(Hora.sec==Alm3_d.sec))
                {
                    lcd.cls();
                    lcd.locate(0,0);                        
                    lcd.printf("Alarma 3 Desactivada");
                    blue =0;
                    wait(.2);
                    blue =1;
                    wait(.2);
                    blue =0;
                    wait(.2);
                    blue =1;
                    wait(.2);
                    blue =0;
                    lcd.locate(0,0);
                    lcd.printf("Adios"); 
                    wait(1);                      
                    m=0;
                    alarma = 0;
                    k=3;
                }
                //Desactivacion  Alarma4               
                if((Hora.date==Alm4_d.date)&&(Hora.mon==Alm4_d.mon)&&(Hora.year==Alm4_d.year)&&(Hora.hour==Alm4_d.hour)&&(Hora.min==Alm4_d.min)&&(Hora.sec==Alm4_d.sec))
                {
                    lcd.cls();
                    lcd.locate(0,0);                        
                    lcd.printf("Alarma 4  Desactivada");
                    wait(1);
                    red =0;
                    wait(.2);
                    red =1;
                    wait(.2);
                    red =0;
                    wait(.2);
                    red =1;
                    wait(.2);
                    red =0;
                    lcd.locate(0,0);
                    lcd.printf("Adios"); 
                    alarma = 0; 
                    wait(1);                     
                    m=0;
                    k=4;
                }                          
                ///////////////////
                
                        break;
            
            
        }
    }

// Lazo de config de hora

hora:
    int i = 0;
    wait(1);
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Segundos: ");
    Hora.sec=0;
    m=0;
    while(i == 0){
            m=wheel.getPulses();        
            if (m!=0){
                Hora.sec=Hora.sec+m;
                if(Hora.sec>59){
                        Hora.sec=59;
                }
                if(Hora.sec<0){
                        Hora.sec=0;
                }
                wheel.reset();  
                m=0;
                }
                lcd.locate(0,1);
                lcd.printf(" "); 
                lcd.locate(0,1);
                lcd.printf("%02d",Hora.sec);
                        
                if (b_en.falling()){
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Minutos: ");
                    Hora.min = 0;
                    i++;
                    m=0;
                }
        } 
    while(i == 1){
            m=wheel.getPulses();        
            if (m!=0){
                Hora.min=Hora.min+m;
                if(Hora.min>59){
                    Hora.min=59;
                }
                if(Hora.min<0){
                    Hora.min=0;
                }
                wheel.reset();  
                m=0;
            }
            lcd.locate(0,1);
            lcd.printf(" "); 
            lcd.locate(0,1);
            lcd.printf("%02d",Hora.min);
            if (b_en.falling()){
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Hora: ");
                Hora.hour = 0;
                i++;
                m=0;
            }
    }
                    
    while(i == 2){
        m=wheel.getPulses();        
        if (m!=0){
            Hora.hour=Hora.hour+m;
            if(Hora.hour>12){
                Hora.hour=12;
            }
            if(Hora.hour<0){
                Hora.hour=0;
            }
            wheel.reset();  
            m=0;
        }
        lcd.locate(0,1);
        lcd.printf("%02d",Hora.hour);
        if (b_en.falling()){
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("Hora definida: ");
            wait(1);
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("Fecha: ");
            wait(1);
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("Dia: ");
            Hora.date = 1; 
            i++;
            m=0;                            
        }
    }
    
    
    while (i == 3){
                m=wheel.getPulses();                             
                if (m!=0){
                    Hora.date=Hora.date+m;
                        if(Hora.date>59){
                            Hora.date=59;
                        }
                        if(Hora.date<1){        
                             Hora.date=1;
                        }
                        wheel.reset();  
                        m=0;
                        lcd.locate(0,1);
                        lcd.printf("%02d",Hora.date);
                }
                        
                if (b_en.falling()){
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Mes: ");
                            Hora.mon = 1;

                }
    } 
    
    while (i == 4){
                m=wheel.getPulses();                             
                if (m!=0){
                    Hora.mon=Hora.mon+m;
                        if(Hora.mon>12){
                            Hora.mon=12;
                        }
                        if(Hora.mon<1){        
                             Hora.mon=1;
                        }
                        wheel.reset();  
                        m=0;
                        lcd.locate(0,1);
                        lcd.printf("%02d",Hora.mon);
                }
                
                if (b_en.falling()){
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Ano: ");
                            Hora.year = 2016;
                }
        }      
    while (i == 5){
                m=wheel.getPulses();                             
                if (m!=0){
                    Hora.year=Hora.year+m;

                        if(Hora.year<2016){        
                             Hora.year=2016;
                        }
                        wheel.reset();  
                        m=0;
                        lcd.locate(0,1);
                        lcd.printf("%02d",Hora.year);
                }
                
                if (b_en.falling()){
                            i++;
                            m=0;
                            lcd.cls();
                            rtc.setTime(Hora, false, false);
                            rtc.startClock();
                }
     }           
         
                    
    while(i == 6){  
            
            lcd.locate(0,0);
            lcd.printf("Esperando Hora ");
            if(rtc.getTime(Hora)){
            
            pc.printf("La hora actual es : %02d:%02d:%02d\n", Hora.hour, Hora.min, Hora.sec); // Me entrega la hora actual
            red = 0;
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("Hora: ");
            lcd.locate(0,1);
            lcd.printf("%02d:%02d:%02d", Hora.hour, Hora.min,Hora.sec);
            red = 1;
            wait(1);
            }
            if (b_en.falling()){
                i++;  
                Lugar = 3;                     
            }
        }
          
    while(i == 7){
    goto menu;
    }             
                
                    

// Lazo de Config Alarmas   
 
alarm:  
int pos=1;
int l =0;

        while(l == 0){    
                m=wheel.getPulses(); 
                lcd.locate(0,0);
                lcd.printf("Configurar Alarma %02d",pos);
                lcd.locate(0,1);
                lcd.printf("-1  -2   -3  -4");
                if (m!=0){
                    pos=pos+m;
                    if(pos<1){
                        pos=1;
                        }
                    if(pos>4){
                        pos=4;
                        }
                    wheel.reset();  
                    m=0;
                }
                if(pos==1){
                    red =0;
                    green =1;
                    blue =1;
                    lcd.locate(0,1);
                    lcd.printf(">");                    
                    lcd.locate(4,1);
                    lcd.printf("-");
                    lcd.locate(9,1);                    
                    lcd.printf("-");
                    lcd.locate(13,1);                    
                    lcd.printf("-");
                    wait(0.1);    
                }
                if(pos==2){
                    red =1;
                    green =0;
                    blue =1;
                    lcd.locate(0,1);
                    lcd.printf("-");                    
                    lcd.locate(4,1);
                    lcd.printf(">");
                    lcd.locate(9,1);                    
                    lcd.printf("-");
                    lcd.locate(13,1);                    
                    lcd.printf("-");                  
                    wait(0.1);
                }
                if(pos==3){         
                    red =1;
                    green =1;
                    blue =0;
                    lcd.locate(0,1);
                    lcd.printf("-");                    
                    lcd.locate(4,1);
                    lcd.printf("-");
                    lcd.locate(9,1);                    
                    lcd.printf(">");
                    lcd.locate(13,1);                    
                    lcd.printf("-");                  
                    wait(0.1);    
                }
                if(pos==4){
                    red =0;
                    green =0;
                    blue =0;
                    lcd.locate(0,1);
                    lcd.printf("-");                    
                    lcd.locate(4,1);
                    lcd.printf("-");
                    lcd.locate(9,1);                    
                    lcd.printf("-");
                    lcd.locate(13,1);                    
                    lcd.printf(">");                  
                    wait(0.1);
                }
                        
                if (b_en.falling()){
                    m=0;
                    l = 1;
                    lcd.cls();
                    lcd.locate(0,0);                        
                    lcd.printf("Selecciono la");
                    lcd.locate(0,2);                        
                    lcd.printf("Alarma numero %02d ",pos);
                    wait(1.5);
                    lcd.cls();
                    
                }

        }       

        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Dia: ");
        t.date = 1; 

    while (l == 1){
                m=wheel.getPulses();                             
                if (m!=0){
                    t.date=t.date+m;
                        if(t.date>31){
                            t.date=31;
                        }
                        if(t.date<1){        
                             t.date=1;
                        }
                        wheel.reset();  
                        m=0;
                        lcd.locate(0,1);
                        lcd.printf("%02d",t.date);
                }
                        
                if (b_en.falling()){
                            a++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Mes: ");
                            t.mon = 1;
                            l = 2;
                }
    }
    while (l == 2){
                m=wheel.getPulses();                             
                if (m!=0){
                    t.mon=t.mon+m;
                        if(t.mon>12){
                            t.mon=12;
                        }
                        if(t.mon<1){        
                             t.mon=1;
                        }
                        wheel.reset();  
                        m=0;
                        lcd.locate(0,1);
                        lcd.printf("%02d",t.mon);
                }
                
                if (b_en.falling()){
                            a++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Ano: ");
                            t.year = 2016;
                            l = 3;
                }
        }      
    while (l == 3){
                m=wheel.getPulses();                             
                if (m!=0){
                    t.year=t.year+m;

                        if(t.year<2016){        
                             t.year=2016;
                        }
                        wheel.reset();  
                        m=0;
                        lcd.locate(0,1);
                        lcd.printf("%02d",t.year);
                }
                
                if (b_en.falling()){
                            a++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Hora: ");
                            t.hour = 0;
                            l = 4;
                }
     }           
    while (l == 4){
                m=wheel.getPulses();                             
                if (m!=0){
                    t.hour=t.hour+m;
                    if(t.hour>23){
                        t.hour=23;
                    }

                    if(t.hour<0){        
                        t.hour=0;
                    }
                    wheel.reset();  
                    m=0;
                    lcd.locate(0,1);
                    lcd.printf("%02d",t.hour);
                }
              
                if (b_en.falling()){
                    a++;
                    m=0;
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Minuto: ");
                    t.min = 0;
                    l = 5;
                }
        }
    while (l == 5){
                m=wheel.getPulses();                             
                if (m!=0){
                    t.min=t.min+m;
                    if(t.min>59){
                        t.min=59;
                    }

                    if(t.min<0){        
                        t.min=0;
                    }
                    wheel.reset();  
                    m=0;
                    lcd.locate(0,1);
                    lcd.printf("%02d",t.min);
                }
                
                if (b_en.falling()){
                    a++;
                    m=0;
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Segundo: ");
                    t.sec = 0;
                    l = 6;
                }
            
        }
    while (l == 6){
                m=wheel.getPulses();                             
                if (m!=0){
                    t.sec=t.sec+m;
                    if(t.sec>59){
                        t.sec=59;
                    }

                    if(t.sec<0){        
                        t.sec=0;
                    }
                    wheel.reset();  
                    m=0;
                    lcd.locate(0,1);
                    lcd.printf("%02d",t.sec);
                }
                
                if (b_en.falling()){

                            if(pos ==1){
                                    Alm=t;
                                    x1=1;    
                                }
                                if(pos ==2){
                                    Alm2=t;
                                    x2=1;    
                                }
                                if(pos ==3){
                                    Alm3=t;    
                                    x3=1;
                                }
                                if(pos ==4){
                                    Alm4=t;    
                                    x4=1;
                                }
                                lcd.cls();
                                lcd.locate(0,1);
                                lcd.printf("Alarma %02d config",pos);
                                wait(1);
                                m=0;
                                lcd.cls();
                                l = 7;
                        }                                               
    }
    
    while(l == 7){
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Prog Desactivacion");
        wait(2);
        l = 8;
    }
    
    while(l == 8){
        if (b_en.falling()){
        l = 9;
        lcd.cls();
        wait(1);
        }
    while(l == 9){
        Lugar=2;
        goto menu;
        }
    }   
desactivar:
l = 1;
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Dia: ");
        t.date = 1; 

    while (l == 1){
                m=wheel.getPulses();                             
                if (m!=0){
                    t.date=t.date+m;
                        if(t.date>31){
                            t.date=31;
                        }
                        if(t.date<1){        
                             t.date=1;
                        }
                        wheel.reset();  
                        m=0;
                        lcd.locate(0,1);
                        lcd.printf("%02d",t.date);
                }
                        
                if (b_en.falling()){
                            a++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Mes: ");
                            t.mon = 1;
                            l = 2;
                }
    }
    while (l == 2){
                m=wheel.getPulses();                             
                if (m!=0){
                    t.mon=t.mon+m;
                        if(t.mon>12){
                            t.mon=12;
                        }
                        if(t.mon<1){        
                             t.mon=1;
                        }
                        wheel.reset();  
                        m=0;
                        lcd.locate(0,1);
                        lcd.printf("%02d",t.mon);
                }
                
                if (b_en.falling()){
                            a++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Ano: ");
                            t.year = 2016;
                            l = 3;
                }
        }      
    while (l == 3){
                m=wheel.getPulses();                             
                if (m!=0){
                    t.year=t.year+m;

                        if(t.year<2016){        
                             t.year=2016;
                        }
                        wheel.reset();  
                        m=0;
                        lcd.locate(0,1);
                        lcd.printf("%02d",t.year);
                }
                
                if (b_en.falling()){
                            a++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Hora: ");
                            t.hour = 0;
                            l = 4;
                }
     }           
    while (l == 4){
                m=wheel.getPulses();                             
                if (m!=0){
                    t.hour=t.hour+m;
                    if(t.hour>23){
                        t.hour=23;
                    }

                    if(t.hour<0){        
                        t.hour=0;
                    }
                    wheel.reset();  
                    m=0;
                    lcd.locate(0,1);
                    lcd.printf("%02d",t.hour);
                }
              
                if (b_en.falling()){
                    a++;
                    m=0;
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Minuto: ");
                    t.min = 0;
                    l = 5;
                }
        }
    while (l == 5){
                m=wheel.getPulses();                             
                if (m!=0){
                    t.min=t.min+m;
                    if(t.min>59){
                        t.min=59;
                    }

                    if(t.min<0){        
                        t.min=0;
                    }
                    wheel.reset();  
                    m=0;
                    lcd.locate(0,1);
                    lcd.printf("%02d",t.min);
                }
                
                if (b_en.falling()){
                    a++;
                    m=0;
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Segundo: ");
                    t.sec = 0;
                    l = 6;
                }
            
        }
    while (l == 6){
                m=wheel.getPulses();                             
                if (m!=0){
                    t.sec=t.sec+m;
                    if(t.sec>59){
                        t.sec=59;
                    }

                    if(t.sec<0){        
                        t.sec=0;
                    }
                    wheel.reset();  
                    m=0;
                    lcd.locate(0,1);
                    lcd.printf("%02d",t.sec);
                }
                
                if (b_en.falling()){

                            if(pos ==1){
                                    Alm_d=t;
                                    x1=1;    
                                }
                                if(pos ==2){
                                    Alm2_d=t;
                                    x2=1;    
                                }
                                if(pos ==3){
                                    Alm3_d=t;    
                                    x3=1;
                                    
                                }
                                if(pos ==4){
                                    Alm4_d=t;    
                                    x4=1;
                                }
                                lcd.cls();
                                lcd.locate(0,1);
                                lcd.printf("Alarma %02d Finalizo",pos);
                                wait(1);
                                m=0;
                                lcd.cls();
                                l = 7;
                        }                                               
    }
    while (l == 7){
        Lugar=3;
        goto menu;
    }        
}