#include "mbed.h"
#include <Pulse1.h>
#include <string.h>
#include "TextLCD.h"
#include "iostream"
#include "stdio.h"
#include "string"
#include "stdlib.h"
#include <BufferedSerial.h>

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5, TextLCD::LCD20x4); // rs, e, d4-d7 Teclado
//asignamos el puerto a cada interruptor
AnalogIn y(PTB3);//entrada analoga
AnalogOut u(PTE30);//salida analoga OJO solo se le pueden drenar 1.5mA en circuitos use un Buffer
//si se ignora esto se arruina la FRDMKL25Z
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
 
DigitalIn button3(PTC16);//cambia ingreso de  los 4 parametros
DigitalIn button4(PTC17);//termina y consolida valores de 4 parametros y sale del loop


//device.baud(115200); 
 
 
//codigos movimiento del curzor
 
//int C1=0x0E; // solo muestra el curzor
int C2=0x18; // desplaza izquierda
int C3=0x1A; // desplaza derecha
int C4=0x0C; // quito cursor bajo
int C1=0x0F;

int cambio=0, diferencia=0;

// se cambio de float a entero
float pid,o,ai,ad,ap,med,err;
float err_v;

// 

// fin del cambio
int spnum=0,kinum=0,kpnum=0,kdnum=0,pos=1;
char buffer[128];
char buffer2[128];
char salidas[32];
char err_s[3];
char spnum_s[3];
char med_s[3];
char co_s[3];
Timer t;
int l;
//control remoto videobeam aula
PulseInOut irda(PTD5);// en este puerto se pone el sensor infrarrojo
Serial pc(USBTX, USBRX);
//PwmOut pwmLed(LED1);

int header =0;
const int head_H = 2880; //+20% medida con osciloscopio en microsegundos
const int head_L = 1920;//-20%  medida con osciloscopio
int i=0,k=0;
const int T_alto=567;//ponga su tiempo de la prueba
const int T_bajo=1170;//ponga su tiempo de la prueba
const int num_bits = 21;//ponga su numero de bits
int num[num_bits];//cadena para almacenar todos los tiempos que conforman los bits de datos
int aux[21];
int vec[4] = {0,0,0,0};
int dato;
   
int SubirCanal[] =   {0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,1};  //Boton para subir el parámetro en la pantalla
int BajarCanal[] =   {1,0,0,0,1,0,0,1,0,0,0,0,1,1,0,0,0,1,0,0,1};  //Boton para bajar el parámetro en la pantalla
int SubirVolumen[] = {0,1,0,0,1,0,0,1,0,0,0,0,1,0,1,0,0,1,0,0,1};//Boton para saltar de parámetro a parámetro
int BajarVolumen[] = {1,1,0,0,1,0,0,1,0,0,0,0,1,1,1,0,0,1,0,0,1};//Boton para iniciar el PID

int main(){
//pwmLed=0;
      

// inicio 
    lcd.locate(0,1);
    lcd.printf("**Control PID**");
    wait(2);
    lcd.cls(); // Borrar Pantalla
    
  //  lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD
 
    lcd.locate(8,0);
    lcd.printf("Kp=%d",kpnum);
    lcd.locate(0,1);
    lcd.printf("Ki=%d",kinum);
    lcd.locate(8,1);
    lcd.printf("Kd=%d",kdnum);
    lcd.locate(0,0);
    lcd.printf("Sp=%d",spnum);
 
    while(1)
    {
        //lcd.locate(8,0);
        //lcd.printf("Kp=%d",encoder.getPulses());
        //wait(.5);

ini1: 
        fflush( stdin );
        header=0;
        //l1=1;
        header = irda.read_low_us();    //funcion para leer un pulso de caida o bajo
        if (header > head_L && header < head_H) goto seguir;//verificar que este en la tolerancia +-20%
        else goto ini1;

seguir:
        wait_us(333);
        //l1=0;
        for(i=0;i<=(num_bits-1);++i){ // POR OSCILOSCOPIO se determina que llegan (num_bits),datos
            dato = irda.read_low_us(); //leer un bit de datos que es pulso arriba en este control
            num[i]=dato;
            wait_us(333);   
        }
        
        wait(0.5); //espero un poquito antes de leer todo el arreglo y ponerlo en pantalla 
        //pc.printf(",%d",header);
        
        for(i=0;i<=(num_bits-1);++i){  
           // pc.printf(",%d",num[i]);
        }
        
        wait(0.1);  //espero  
        pc.printf("\n\n");//imprimo en binario
        for(i=0;i<=(num_bits-1);++i){  
            if(num[i] > ((T_alto+T_bajo)/2)){
               //  pc.printf("1");
                 aux[i]=1;
            }
            else { 
            //pc.printf("0");
                aux[i]=0;
            }
        }        
 // pc.printf("%d",aux[0]);
if  ( aux[0]==SubirCanal[0]&&aux[1]==SubirCanal[1]&&aux[2]==SubirCanal[2]&&aux[3]==SubirCanal[3]&&aux[4]==SubirCanal[4]){  
         diferencia=10 ; 
         pc.printf("sumo");
}
else if (aux[0]==BajarCanal[0]&&aux[1]==BajarCanal[1]&&aux[2]==BajarCanal[2]&&aux[3]==BajarCanal[3]&&aux[4]==BajarCanal[4]){
         diferencia=-1;  
         pc.printf("resto");
}
 
i=pos; 
vec[i-1] = vec[i-1]+diferencia;

for(k=0;k<=3;k++){
    if(vec[k]<=0)
        vec[k]=0;
    if(vec[k]>=999)
        vec[k]=999;
}

diferencia = 0;
spnum = vec[0];
kpnum = vec[1];
kinum = vec[2];
kdnum = vec[3];


switch (pos){
    case 1:
        lcd.locate(3,0);
        lcd.printf("    "); 
        lcd.locate(3,0);
        lcd.printf("%d", spnum); 
    case 2:
        lcd.locate(11,0);
        lcd.printf("    "); 
        lcd.locate(11,0);
        lcd.printf("%d", kpnum); 
    case 3:
        lcd.locate(3,1);
        lcd.printf("    "); 
        lcd.locate(3,1);
        lcd.printf("%d", kinum); 
     case 4:
        lcd.locate(11,1);
        lcd.printf("    "); 
        lcd.locate(11,1);
        lcd.printf("%d", kdnum); 
}
// lcd.writeCommand(C1);
if (aux[0]==SubirVolumen[0]&&aux[1]==SubirVolumen[1]&&aux[2]==SubirVolumen[2]&&aux[3]==SubirVolumen[3]&&aux[4]==SubirVolumen[4])  //cambia la posicion de ingreso de parametros
{
            pc.printf("salto");
            led3 =!led3;

            if (pos == 4)
            {
                pos=1;
                lcd.locate(3,0);
                lcd.printf("%d", spnum);
                
            }
            else if (pos == 1)
            {
                pos = 2;
                lcd.locate(11,0);
                lcd.printf("%d", kpnum);
            }
            else if(pos == 2)
            {
                pos = 3;
                lcd.locate(3,1);
                lcd.printf("%d", kinum);
            }
            else if(pos == 3)
            {
                pos = 4;
                lcd.locate(11,1);
                lcd.printf("%d", kdnum);
            }
            wait(0.25);
 
}
  if (aux[0]==BajarVolumen[0]&&aux[1]==BajarVolumen[1]&&aux[2]==BajarVolumen[2]&&aux[3]==BajarVolumen[3]&&aux[4]==BajarVolumen[4])
        {
            break;     //sale del bucle si pisan suiche4
        }
        wait(0.1);

    }
 
 
 
 pc.printf("sp:%d kp:%d ki:%d kd:%d",spnum,kpnum,kinum,kdnum);
//Transicion
    lcd.writeCommand(C4);//escribimos un comando segun el manual del modulo LCD para quitar cursor bajo
    lcd.cls(); //borra la pantalla
    lcd.printf("   GUARDADOS!");
    wait(1);
    lcd.cls();
    lcd.printf(" INICIA EL PID");
    wait(1);
// se imprimen los parches del control  *****************************************
    lcd.cls();
    lcd.printf("Er=%3.0f",err);
    lcd.locate(8,0);
    lcd.printf("Me=%3.0f",med);
    lcd.locate(0,1);
    lcd.printf("Sp=%3.0f",spnum);
    lcd.locate(8,1);
    lcd.printf("Co=%3.0f",pid);
    wait(1);
 
// CICLO PRINCIPAL CONTROLADOR PID
 lop1:  med = y.read()*999;
        err = (spnum-med);  //se calcula el error
        ap = kpnum*err*0.01f;     //se calcula la accion proporcinal
        ai =(kinum*err*0.01f)+ai;    //calculo de la integral del error
        ad = kdnum*(err-err_v)*0.01f; //calculo de la accion derivativa
        pid = (ap+ai+ad);
        // se verifica que pid sea positivo **************************************
        if(pid<=0)
        {
            pid=0;
        }
 
        // se verifica que pid sea menor o igual la valor maximo *****************
        if (pid > 999)
        {
            pid=999;
        }
 
       
        //se muestran las variables******************************************
            lcd.locate(3,0);
            lcd.printf("    ");
            lcd.locate(3,0);
            lcd.printf("%3.0f",err);
            lcd.locate(11,0);
            lcd.printf("   ");
            lcd.locate(11,0);
            lcd.printf("%3.0f",med);
            lcd.locate(3,1);
            lcd.printf("   ");
            lcd.locate(3,1);
            lcd.printf("%d",spnum);
            lcd.locate(11,1);
            lcd.printf("   ");
            lcd.locate(11,1);
            lcd.printf("%3.0f",pid);

        
        
     // Fin de la modificacion
            
        //Normalizacion de la salida
        // se actualizan las variables *******************************************
        err_v = err;
        o = pid/999;
        u.write(o);
        //  se envia el valor pid a puerto analogico de salida (D/A) **************
        
        //  se repite el ciclo
        wait_ms(300);
        goto lop1;
}
