#include "mbed.h"
#include "wdt.h"

// Sample program using the Watchdog
// ---------------------------------
//    * Three threads co-operate to flash two LEDs
//    * A simple way to inject a fault, by pressing a button 
//    * The watchdog is configured with a 32ms timeout

#define ON 1
#define OFF 0
DigitalOut led_red(LED_RED, ON);
DigitalIn button(PTD0, PullUp);
DigitalOut led1(PTC12, OFF);
DigitalOut led2(PTC13, OFF);

Serial pc(USBTX, USBRX); // tx, rx, useful for debugging

// This ticker is used to feed the watch dog
//Ticker tick;

// Threads
Thread threadT ; // timer thread 
Thread threadLED1 ; // thread LED1
Thread threadLED2 ; // thread LED2

# define ON1 0x01   
# define ON2 0x02
# define OFF1 0x04   
# define OFF2 0x08
# define firstthreadhappy 0x16
# define secondthreadhappy 0x32
# define thirdthreadhappy 0x64
EventFlags signals;  // event flags for signalling


// ------------Fault Injection Button-------------
//  Wait while the button is down
//     Use this to simulate a STUCK fault
// -----------------------------------------------
void waitButton() {
    while (!button) ;  
}

// ---Thread for controlling LED 1----------------
//   Turn LED1 on/off in response to signals 
// -----------------------------------------------
void led1_thread() {  // method to run in thread
    int evt ;
    while (true) {
        evt = signals.wait_any(ON1 | OFF1); // wait for either signal
        if (evt & ON1) led1 = ON ;
        if (evt & OFF1) led1 = OFF ;
        signals.set(firstthreadhappy);
        //waitButton() ;  // POSSIBLE FAULT HERE
        
    }
}

// ---Thread for controlling LED 2----------------
//   Turn LED2 on/off in response to signals 
// -----------------------------------------------
void led2_thread() {  // method to run in thread
    int evt ;
    while (true) {
        evt = signals.wait_any(ON2 | OFF2); // wait for any signal
        if (evt & ON2) led2 = ON ;
        if (evt & OFF2) led2 = OFF ;
        signals.set(secondthreadhappy);
        // waitButton() ; // POSSIBLE FAULT HERE
        
    }
}

// ---Thread for timing --------------------------
//   Send signals to the other threads
// -----------------------------------------------
void timer_thread() {  // method to run in thread
    //int evt;
    while (true) {
        wait(0.8) ;
        signals.set(ON1 | ON2) ;
        signals.set(thirdthreadhappy);
        wait(0.8) ;
        signals.set(OFF1 | OFF2) ;
        signals.set(thirdthreadhappy);
        // waitButton() ; // POSSIBLE FAULT HERE
    }
}

// -----------MAIN-------------------------------
//    Configure watchdog. Start threads. 
//    Show start up with RED for 1sec
//    Remember the watchdog is running
//       - 1024ms to set it once
//       - then must feed it every 32ms  
// ----------------------------------------------

int main(void) {
    wdt_1sec() ; // initialise watchdog - 1s timeout
    wdt_kick_all() ;
    //tick.attach_us(callback(&wdt_kick_all), 20000);    
    int evt;
    int first;
    int second;
    int third;
    // start threads
    threadT.start(timer_thread) ; // start the timer thread 
    threadLED1.start(led1_thread) ; // start the LED1 control thread 
    threadLED2.start(led2_thread) ; // start the LED2 control thread 
    
    led_red = OFF;
    wait(0.5) ;
    led_red = ON;
    
    while(1){
        evt = signals.wait_any(firstthreadhappy | secondthreadhappy | thirdthreadhappy);
        if(evt & firstthreadhappy) first = 1;
        if(evt & secondthreadhappy) second = 1;
        if(evt & thirdthreadhappy) third = 1;
        
        if(first + second + third == 3) {
            wdt_kick_all() ;
            first = 0;
            second = 0;
            third = 0;
        }    
            
    }
    //if(firstthreadhappy) callback(&wdt_kick_all); // ticks every 20ms
    
    // show start-up
    
    // main thread terminates
    
    
}