#include "mbed.h"
#include "TSISensor.h"

// Example program for lab 5
// -------------------------
//  A value is read from the touch sensor and use
//    to control two LEDs
//  The value is also output to the serial interface

Serial pc(USBTX, USBRX); // tx, rx
DigitalOut redLED(LED_RED);
DigitalOut greenLED(LED_GREEN);
DigitalOut blueLED(LED_BLUE);
TSISensor tsi;

Thread redThread ; // thread for red LED
Thread greenThread ; // thread for green LED
Thread blueThread;
Thread whiteThread;

# define REDFLAG 0x01   
# define GREENFLAG 0x02
# define BLUEFLAG 0x04
# define WHITEFLAG 0x08
EventFlags signals;  // event flags for signalling; 2 used

enum redLEDState {REDOn,REDOff}; 
void red_thread() {  // method to run in thread
    redLEDState redstate = REDOff; 
    while (true) {
        switch(redstate){
            case REDOff:
                signals.wait_any(REDFLAG);
                redLED = false;
                wait(0.5);
                redstate = REDOn;
                break;
            case REDOn: 
                redLED = true ; // turn on
                signals.clear(REDFLAG);
                redstate = REDOff;
        }
    }
}
enum greenLEDState {GREENOn,GREENOff}; 
void green_thread() {  // method to run in thread
    greenLEDState greenstate = GREENOff; 
    while (true) {
        switch(greenstate){
            case GREENOff:
                signals.wait_any(GREENFLAG);
                greenLED = false ; 
                wait(0.5);
                greenstate = GREENOn;
                break;
            case GREENOn: 
                greenLED = true ; // turn on
                signals.clear(GREENFLAG);
                greenstate = GREENOff;
        }
    }
}
enum blueLEDState {BLUEOn,BLUEOff}; 
void blue_thread() {  // method to run in thread
    blueLEDState bluestate = BLUEOff; 
    while (true) {
        switch(bluestate){
            case BLUEOff:
                signals.wait_any(BLUEFLAG);
                blueLED = false ; 
                wait(0.5);
                bluestate = BLUEOn;
                break;
            case BLUEOn: 
                blueLED = true ; // turn on
                signals.clear(BLUEFLAG);
                bluestate = BLUEOff;
        }
    }
}
enum whiteLEDState {WHITEOn,WHITEOff}; 
void white_thread() {  // method to run in thread
    whiteLEDState whitestate = WHITEOff; 
    while (true) {
        switch(whitestate){
            case WHITEOff:
                signals.wait_any(WHITEFLAG);
                blueLED = false ; // turn on 
                redLED = false ;
                greenLED = false ;
                wait(0.5);
                whitestate = WHITEOn;
                break;
            case WHITEOn: 
                blueLED = true ; // turn off 
                redLED = true ;
                greenLED = true ;
                signals.clear(WHITEFLAG);
                whitestate = WHITEOff;
        }
    }
}

enum states {LeftIn,LeftOut,RightIn,RightOut,None};

int main(void) {
    redLED = true ; // turn off 
    greenLED = true ; // turn off 
    blueLED = true ;
    redThread.start(red_thread) ; // start the red thread
    greenThread.start(green_thread) ; // start the green thread
    blueThread.start(blue_thread);
    whiteThread.start(white_thread);
    
    states State = None;
    
    while (true) {
        uint8_t d = tsi.readDistance() ;  // Distance is between 0 and 39
                                          // When no touch --> 0
                                          // Left --> low value  Right --> high value
        pc.printf("%d", d) ;  
        pc.putc(' ') ;
        wait(0.1);
        switch(State){
            case None:
               if (d > 3 && d < 9) {signals.set(REDFLAG);State = LeftOut;}
               else if (d > 13 && d < 19) {signals.set(GREENFLAG) ;State = LeftIn; }
               else if (d > 23 && d < 29) {signals.set(BLUEFLAG) ;State = RightIn;}  
               else if (d > 33) {signals.set(WHITEFLAG) ;State = RightOut;}
               break;
            case LeftOut:
                if (d < 3 || d >9) State = None;break;
            case LeftIn:
                if (d < 13 || d >19) State = None;break;
            case RightIn:
                if (d < 23 || d >29) State = None;break;
            case RightOut:
                if (d < 33) State = None;break;
        }
    }
}