#include "mbed.h"
#include "MMA8451Q.h"

  PinName const SDA = PTE25;
  PinName const SCL = PTE24;

#define MMA8451_I2C_ADDRESS (0x1d<<1)

enum orientation {Intermediate,FlatUp,FlatDown,Left,Right,Forwards,Backwards};

int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);
    Serial pc(USBTX, USBRX); // tx, rx
    
    orientation orient = Intermediate;
    
    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    while (true) {
        float x, y, z;
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        //pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n", x, y, z);
        
        switch (orient){
            case Intermediate:
                if(0.9<z && z<1.1){
                    pc.printf("The TouchPad is flat\r\n");
                    orient = FlatUp;
                }
                else if(-0.9>z && z>-1.1){
                    pc.printf("The TouchPad is facing the floor\r\n");
                    orient = FlatDown;
                }
                else if(0.9<y && y<1.1){
                    pc.printf("The TouchPad is tipped to the right\r\n");
                    orient = Right;
                }
                else if(-0.9>y && y>-1.1){
                    pc.printf("The TouchPad is tipped to the left\r\n");
                    orient = Left;
                }
                else if(0.9<x && x<1.1){
                    pc.printf("The TouchPad is tipped forwards\r\n");
                    orient = Forwards;
                }
                else if(-0.9>x && x>-1.1){
                    pc.printf("The TouchPad is tipped backwards\r\n");
                    orient = Backwards;
                }   
                break ;
            case FlatUp:
                if(0.9<z && z<1.1){
                    rled = 1.0f - abs(z);
                    gled = 1.0f - abs(y);
                    bled = 1.0f - abs(x);
                }
                else{
                    orient = Intermediate;
                }
                break;    
            case FlatDown:
                if(-0.9>z && z>-1.1){
                    rled = 1.0f - abs(z);
                    gled = 1.0f - abs(y);
                    bled = 1.0f - abs(x);
                }
                else{
                    orient = Intermediate;
                }
                break;    
            case Forwards:
                if(0.9<x && x<1.1){
                    rled = 1.0f - abs(z);
                    gled = 1.0f - abs(y);
                    bled = 1.0f - abs(x);
                }
                else{
                    orient = Intermediate;
                } 
                break;    
            case Backwards:
                if(-0.9<x && x<-1.1){
                    rled = 1.0f - abs(z);
                    gled = 1.0f - abs(y);
                    bled = 1.0f - abs(x);
                }
                else{
                    orient = Intermediate;
                }
                break;
            case Right:
                if(0.9<y && y<1.1){
                    rled = 1.0f - abs(z);
                    gled = 1.0f - abs(y);
                    bled = 1.0f - abs(x);
                }
                else{
                    orient = Intermediate;
                }
                break;
            case Left:
                if(-0.9<y && y<-1.1){
                    rled = 1.0f - abs(z);
                    gled = 1.0f - abs(y);
                    bled = 1.0f - abs(x);
                }
                else{
                    orient = Intermediate;
                } 
                break;
        }    
        
        
        wait(0.1);
    }
}
