// Lab 3 Example Program 2
// -----------------------
// Periodically write to the AnalogOut to create a sine wave
// Alternate between two fixed frequencies every 5 sec
// 
// This code uses the Ticker API to create a periodic interrupt
// Devices used in this way must not call locks; a variant of 
//   the AnalogOut device w/o locking is created for this.
//
// Updated for mbed 5

// THIS VERSION HAS NO DEBUGGING CODE

#include "mbed.h"
#include "sineTable.h"

// --------------------------
// This declaration introduces a derived version of the mbed AnalogOut
//   class with the locking removed.
// You do NOT NEED TO UNDERSTAND this 
class AnalogOut_unsafe : public AnalogOut {
  public:
    AnalogOut_unsafe (PinName pin) : AnalogOut (pin) {} 
  protected: 
    virtual void lock() {}
    virtual void unlock() {}
};
// --------------------------

Ticker tick ;          // Creates periodic interrupt
AnalogOut_unsafe ao(PTE30) ;  // Analog output

AnalogIn ain(A0) ;          // Analog input

DigitalOut led0(PTA13);
DigitalOut led1(PTD5);
DigitalOut led2(PTD0);
DigitalOut led3(PTD2);
DigitalOut led4(PTD3);

DigitalIn b1(PTA1, PullUp);

EventQueue queue;  // creates an event queue, to call read ADC

Serial pc(USBTX, USBRX); // tx, rx, for debugging

// This thread runs the event queue
Thread eventThread ;

typedef struct {
  uint16_t analog; /* Analog input value */
  int button;
} message_t;

Mail<message_t, 2> mailbox;

volatile int samples = 0 ;
volatile uint16_t smoothed = 0 ; 

volatile int pressEvent = 0 ;

enum buttonPos { up, down, bounce }; // Button positions

buttonPos pos = up ;
int bcounter = 0 ;

void readA0() {   
    smoothed = (smoothed >> 1) + (ain.read_u16() >> 1) ;
    samples++ ;
    
    switch (pos) {
            case up :
                if (!b1.read()) {    // now down 
                    pressEvent = 1 ;  // transition occurred
                    pos = down ;
                }
                break ;
            case down : 
                if (b1 == 1) { // no longer down
                    bcounter = 3 ; // wait four cycles
                    pos = bounce ;
                }
                break ;
            case bounce :
                if (b1 == 0) { // down again - button has bounced
                    pos = down ;   // no event
                } else if (bcounter == 0) {
                    pos = up ;     // delay passed - reset to up
                } else {
                    bcounter-- ;   // continue waiting
                }
                break ;
        }
        wait(0.03);
    
    if (samples == 10) {
        // send to thread
        message_t *mess = mailbox.alloc() ; // may fail but does not block
        if (mess) {
            mess->analog = smoothed ;
            mess->button = pressEvent ;
            mailbox.put(mess); // fails but does not block if full
            pressEvent = 0;// clear press
        }
        samples = 0;
        
    }
}

// Function called periodically
// Write new value to AnalogOut 
volatile int index = 0 ; // index into array of sin values
void writeAout() {
    ao.write_u16(sine[index]) ;
    index = (index + 1) % 64 ;   
}

// Control the frequency of updates
//   Alternative between two frequencies      
int main() {
    led0 = 0 ; // turn off 
    led1 = 0 ;
    led2 = 0 ;
    led3 = 0 ;
    led4 = 0 ;
    
    int volts = 0 ;
    int threshold[] = {55,110,165,220,275,330} ;
    int counter = 0 ;
    
    eventThread.start(callback(&queue, &EventQueue::dispatch_forever));

    // call the readA0 function every 10ms 
    queue.call_every(10, readA0) ;
    
    
    int update_us = 1000 ; // 1ms
    int freq = 1;
    while (true) {
        osEvent evt = mailbox.get(); // wait for mail 
        if (evt.status == osEventMail) {
            message_t* mess = (message_t*)evt.value.p ;
            volts = (mess->analog * 330) / 0xffff ;
            int mypressEvent = mess->button;
            mailbox.free(mess) ;  // free the message space
            if(mypressEvent) {
                for(int i = 0; i<5;i++){
                    threshold[i] = (i*volts)/6;
                }// use volts to reset thresholds
            } 
            if (volts > threshold[0] ) led0 = 1 ; else led0 = 0 ;
            if (volts > threshold[1]) led1 = 1 ; else led1 = 0 ;
            if (volts > threshold[2]) led2 = 1 ; else led2 = 0 ;
            if (volts > threshold[3]) led3 = 1 ; else led3 = 0 ;
            if (volts > threshold[4]) led4 = 1 ; else led4 = 0 ;
            //vToString(volts, vstring) ;
            counter++ ;
        }
        //tick.attach_us(callback(&writeAout), update_us); // setup ticker to write to AnalogOut
        //wait(30.0) ; // wait 30 sec 
        freq = 1+((49*volts)/330);
        update_us = 1000000/(freq*64);
        //update_us = 2000 ; // 2ms
        tick.attach_us(callback(&writeAout), update_us); // setup ticker to write to AnalogOut
        //wait(30.0) ; // wait 30 sec 
        //update_us = 1000 ; // 1ms
    }
}
