#include "mbed.h"

// Labs 2: Example program for using an interrupt (or callback)
// -----------------------------------------------------------
// A callback function (corresponding to an ISR) is called when a button 
//    is pressed
// The callback uses a shared variable to signal another thread

InterruptIn button(PTD0);
InterruptIn button1(PTD2);
DigitalOut led(LED_BLUE);
DigitalOut led1(LED_RED);

volatile int pressEvent = 0 ;
volatile int pressEvent1 = 0 ;

bool ledflashing = true;
bool led1flashing = true;

enum blueledState { Flashing, NotFlashing };
enum redledState { Flashing1, NotFlashing1 };

// This function is invoked when then interrupt occurs
//   Signal that the button has been pressed
//   Note: bounce may occur 
void buttonCallback(){
    pressEvent = 1 ;
}

void buttonCallback1(){
    pressEvent1 = 1 ;
}

/*  ---- Main function (default thread) ----
    Note that if this thread completes, nothing else works
 */
int main() {
    button.mode(PullUp);             // Ensure button i/p has pull up
    button.fall(&buttonCallback) ;   // Attach function to falling edge
    
    button1.mode(PullUp);             // Ensure button i/p has pull up
    button1.fall(&buttonCallback1) ;   // Attach function to falling edge
    
    led = 1;
    led1 = 1;

    blueledState State1 = Flashing;
    redledState State2 = Flashing1;
    int count = 5;
    int count1 = 5;
    while(true) {
        wait(0.1);
        switch(State1){
            case Flashing:
                if(pressEvent){
                    State1 = NotFlashing;
                    pressEvent = 0;
                }    
                else{
                    if(count!=0){
                        count-- ; 
                    }
                    else if(count == 0){
                        led = !led ; 
                        count = 5;        
                    } 
                }
            case NotFlashing: 
                if(pressEvent){
                    State1 = Flashing;
                    count = 5;
                    pressEvent = 0;
                }  
        }        
        switch(State2){
            case Flashing1:
                if(pressEvent1){
                    State2 = NotFlashing1;
                    pressEvent1 = 0;
                }    
                else{
                    if(count1!=0){
                        count1-- ; 
                    }
                    else if(count1 == 0){
                        led1 = !led1 ; 
                        count1 = 5;        
                    } 
                }
                break;
            case NotFlashing1:        
                if(pressEvent1){
                    State2 = Flashing1;
                    count1 = 5;
                    pressEvent1 = 0;
                }
                break;
        }
        
    }
}