/* 
 * Nikola Aničić 2019/0099 
 * ETF Beograd
 * napisano 20/11/2021
 *
 * Zadatak 3.3 - Napisati program koji 
 *               na pritisak tastera (a ne dok je pritisnut taster) SW1 
 *               prikazuje proizvoljnu bitmapu na OLED displeju,
 *               dok je ponovnim pritiskom tastera briše sa displeja.
 */

#include "mbed.h"
// Potrebne biblioteke za Adafruit
#include "Adafruit_GFX.h"
#include "Adafruit_GFX_Config.h"                                                /* Sve potrebne funkcionalnosti su otkomentarisane */
#include "Adafruit_SSD1306.h"    
// Custom headers za bitmape
#include "bitmaps.h"
 
 // I2C bus                  
 #define SCL                 PB_13
 #define SDA                 PB_14
 // I2C address
 #define I2C_ADDRESS         0x3C
 #define I2C_ADDRESS_MBED    I2C_ADDRESS << 1
 // I2C frequency
 #define FREQ                400000 // 400 kHz
 // OLED dimensions
 #define OLED_HEIGHT_PX      64
 #define OLED_WIDTH_PX       128
 // Refresh Rate 
 #define RFR_MS              5
 #define SHR_MS              5
 // Rectangle Dimensions
 #define RECT_HEIGHT         OLED_HEIGHT_PX
 #define RECT_WIDTH          OLED_WIDTH_PX
 // Scalers
 #define WIDTH_SCALE         128
 #define HEIGHT_SCALE        64
 #define OFFSET              0.5f
 
 #define RESET_PIN           PB_5                                               /* Neaktivno, ali potrebno za inicijalizaciju displeja */
 
 I2C                         i2c_obj(SDA, SCL); 
 Adafruit_SSD1306_I2c        myOLED(                                            /* Pogledaj Adafruit_SSD1306.cpp dokumentaciju */
                                    i2c_obj, 
                                    RESET_PIN, 
                                    I2C_ADDRESS_MBED, 
                                    OLED_HEIGHT_PX, 
                                    OLED_WIDTH_PX
                                    );

// Kontrolni signali
DigitalIn                    SW1(PC_9);

static int x, y = 0;
static int button_down = 0;
static bool display_state = 0;                                                  /* State 0: Crno, State 1: Prikaz. */
static const unsigned char *bitmap = csmBitmap;                                 /* Dozvoljava odabir proizvoljne bitmape iz header-a */

// Inicijalizacija funkcija
void displayImage(const unsigned char *);

 int main () 
 {
    // Inicijalizacija programa -- Uspostavljanje komunikacije sa displejom i postavka brzine komunikacije.
    i2c_obj.frequency(FREQ);
    myOLED.begin();
    
    while(1) 
    {
        if (!SW1)
        // Stanje: Dugme aktivno pritisnuto.
        {
           button_down = 1;
        }
        else
        {
           if(button_down && !display_state)
           // Stanje: Dugme neposredno bilo pritisnuto, displej ugasen. -> Pali displej
           {
              button_down = 0;
              display_state = 1;
              
              displayImage(bitmap);
           }
           else if (button_down && display_state)
           // Stanje: Dugme neposredno bilo pritisnuto, displej upaljen. -> Gasi displej
           {
              button_down = 0;
              display_state = 0;
              
              myOLED.clearDisplay();
              myOLED.display();
              
              wait_ms(RFR_MS);
           }
        }
        
        printf("\rBD: %d, DS: %d, SW1: %d", button_down, display_state, SW1.read());
        // By default obavestava o stanju preko serijalnog monitora
    }
 }
 
 void displayImage(const unsigned char *bitmap)
 {
    myOLED.clearDisplay();
    myOLED.drawBitmap(x, y, bitmap, OLED_WIDTH_PX, OLED_HEIGHT_PX, WHITE);
    myOLED.display();
    
    display_state = 1;                                                          /* Potrebno kako bi postao aktivan signal za gasenje pri sledecem pritisku SW1 */
    
    wait_ms(RFR_MS);
 }
 
    /* Dodatni resursi */
    // https://javl.github.io/image2cpp/ --> za bitmape
    // Code Output Format -> Adafruit GFX Bitmap format; Vertical 1-bit-per-pixel
    
    // https://ezgif.com/ --> za dekonstrukciju gif-a
    // https://www.mischianti.org/images-to-byte-array-online-converter-cpp-arduino/#Byte_array_generator --> Za properly separated 2D byte array
 