/* 
 * Nikola Aničić 2019/0099 
 * ETF Beograd
 * napisano 06/11/2021
 */
 // Prilikom objave: Ime, Prezime, Broj indeksa (all caps)
 
 // Skinuti JP1 i JP2; JP3 mora da bude na mestu. 
 
 /*
  * Uvoz biblioteka
  */
  #include "mbed.h"
  
  /*
   * Definicije
   */
   #define POLLING_TIME 5 // Dva poliranja po promeni radi multipleksiranja displeja za T1
   #define INITIAL_WAIT 1

   #define FREQ_SCALE 5000
   
   #define ZERO 0xC0
   #define ONE 0xF9
   #define TWO 0xA4
   #define THREE 0xB0
   #define FOUR 0x99
   #define FIVE 0x92
   #define SIX 0x82
   #define SEVEN 0xF8
   #define EIGHT 0x80
   #define NINE 0x90
   
  /*
   * Globalne promenljive
   */
   
   // abcdefg = PA_10, PA_9, PA_8, PB_10, PB_5, PB_4, PB_3
   // SEL1 = PB_6
   // SEL2 = PC_7
   
   // FREQ je u opsegu {5 ms, 5 us}
   
   //               a     b      c     d     e      f    g     = gfedcba ; Na celu je DP uvek 1
   BusOut display(PA_10, PA_9, PA_8, PB_10, PB_5, PB_4, PB_3);
   DigitalOut SEL1 = PB_6;
   DigitalOut SEL2 = PC_7;
   
   AnalogIn POT1(PA_0);
   AnalogIn POT2(PA_1);
   
   PwmOut buzz (PA_11);
   
   InterruptIn SW1(PC_9);   // SW1
   //DigitalIn SW2(PC_8);     // SW2

   // static int tracker = 0;
   static bool showResult = 0;
   
   int sec_digit = 0;
   int prim_digit = 0;
   
  /*
   * Deklaracija funkcija
   */
   
   void ISR_SW1(void);
   
   int main() {
       // Inicijalizacija
       SEL2.write(1);
       SEL1.write(1);
       SW1.fall(&ISR_SW1);
       
       wait(INITIAL_WAIT);
       
       // Petlja
       while(true){
           
           float freq = POT2.read() * FREQ_SCALE + 30;
           
           buzz.period_us(freq);
           buzz.write(POT1.read()); 
           
           // Potenciometar 1 uopste ne reaguje na promene fizickog potenciometra.
           // Proverio sam za PA_0 zadatak Z2_02 i ocitavanje se slicno ne menja.
           
           // POT1 je proradio nakon dodatnog pritiska na plocu
           // kontakt izmedju ploce i maticne je ranije (pre vadjenja JP1 i 2) pravio probleme 
           // za povezanost displeja i zahtevao slicne mere.
           
           printf("\r%2.2f%% %.2f us", POT1.read()*100, freq);
           
           int curr_percentage = POT1.read()*100;
           
           
           if (showResult){
              
              sec_digit = curr_percentage/10;
              prim_digit = curr_percentage%10;
              
              showResult = 0;
            }
            
            
              SEL1.write(1);
              
              //ispis na displej
              switch (prim_digit){
                  case 0: 
                  
                  SEL2.write(0);
                  display.write(ZERO);
                  wait_ms(POLLING_TIME);
                  
                  break;
                  case 1: 
                  
                  SEL2.write(0);
                  display.write(ONE);
                  wait_ms(POLLING_TIME);
                  
                  break;
                  case 2: 
                  
                  SEL2.write(0);
                  display.write(TWO);
                  wait_ms(POLLING_TIME);
                  
                  break;
                  case 3: 
                  
                  SEL2.write(0);
                  display.write(THREE);
                  wait_ms(POLLING_TIME);
                  
                  break;
                  case 4: 
                  
                  SEL2.write(0);
                  display.write(FOUR);
                  wait_ms(POLLING_TIME);
                  
                  break;
                  case 5: 
                  
                  SEL2.write(0);
                  display.write(FIVE);
                  wait_ms(POLLING_TIME);
                  
                  break;
                  case 6: 
                  
                  SEL2.write(0);
                  display.write(SIX);
                  wait_ms(POLLING_TIME);
                  
                  break;
                  case 7: 
                  
                  SEL2.write(0);
                  display.write(SEVEN);
                  wait_ms(POLLING_TIME);
                  
                  break;
                  case 8: 
                  
                  SEL2.write(0);
                  display.write(EIGHT);
                  wait_ms(POLLING_TIME);
                  
                  break;
                  case 9: 
                  
                  SEL2.write(0);
                  display.write(NINE);
                  wait_ms(POLLING_TIME);
                  
                  break;
              }
              
              SEL2.write(1);
              
              switch (sec_digit){
                  case 0: 
                  
                  SEL1.write(1);
                  break;
                  case 1: 
                  
                  SEL1.write(0);
                  display.write(ONE);
                  wait_ms(POLLING_TIME);
                  
                  break;
                  case 2: 
                  
                  SEL1.write(0);
                  display.write(TWO);
                  wait_ms(POLLING_TIME);
                  
                  break;
                  case 3: 
                  
                  SEL1.write(0);
                  display.write(THREE);
                  wait_ms(POLLING_TIME);
                  
                  break;
                  case 4: 
                  
                  SEL1.write(0);
                  display.write(FOUR);
                  wait_ms(POLLING_TIME);
                  
                  break;
                  case 5: 
                  
                  SEL1.write(0);
                  display.write(FIVE);
                  wait_ms(POLLING_TIME);
                  
                  break;
                  case 6: 
                  
                  SEL1.write(0);
                  display.write(SIX);
                  wait_ms(POLLING_TIME);
                  
                  break;
                  case 7: 
                  
                  SEL1.write(0);
                  display.write(SEVEN);
                  wait_ms(POLLING_TIME);
                  
                  break;
                  case 8: 
                  
                  SEL1.write(0);
                  display.write(EIGHT);
                  wait_ms(POLLING_TIME);
                  
                  break;
                  case 9: 
                  
                  SEL1.write(0);
                  display.write(NINE);
                  wait_ms(POLLING_TIME);
                  
                  break;
              }
        }
    }
    
  /*
   * Funkcije
   */
   
   void ISR_SW1(){
      showResult = 1;
      //here 
    }
   