#include "mbed.h"
#include "rtos.h"
#include "SDFileSystem.h"
#include "uLCD_4DGL.h"
#include "wave_player.h"
#include "MSGEQ7.h"
 
#define MAX 700
 
MSGEQ7 eq(p13, p14, p15);
SDFileSystem sd(p5, p6, p7, p8, "sd");
uLCD_4DGL uLCD(p9,p10,p17);
Mutex lcd_mutex;
AnalogOut DACout(p18);
wave_player waver(&DACout);
Serial pc(USBTX, USBRX);
Mutex serialm;
PwmOut red(p21);
PwmOut green(p22);
PwmOut blue(p23);


Thread music;
Thread image;
Thread info;
Thread Lighting;

void music_thread(){
    FILE *wave_file;
    wave_file=fopen("/sd/mydir/fys.wav","r");
    waver.play(wave_file);
    fclose(wave_file);
    Thread::wait(1000);
    }
    
void image_thread(){
    while(1){
    lcd_mutex.lock();
    uLCD.media_init();
    uLCD.set_sector_address(0x0000, 0x001E);
    uLCD.display_image(0,0);
    lcd_mutex.unlock();
    }
    }

void info_thread(){
     while(1) {
        eq.readInt(MAX);
        lcd_mutex.lock();
        for(int i = 0; i < 7; i++){
            if (eq.freqDataInt[i] > 10){
                uLCD.filled_circle(22+i*14, 106, 6, GREEN);
                }
            if (eq.freqDataInt[i] > 100){
                uLCD.filled_circle(22+i*14, 92, 6, GREEN);
                }
            if (eq.freqDataInt[i] > 200){
                uLCD.filled_circle(22+i*14, 78, 6, GREEN);
                }
            if (eq.freqDataInt[i] > 300){
                uLCD.filled_circle(22+i*14, 64, 6, GREEN);
                }
            if (eq.freqDataInt[i] > 400){
                uLCD.filled_circle(22+i*14, 50, 6, GREEN);
                }
            if (eq.freqDataInt[i] > 500){
                uLCD.filled_circle(22+i*14, 36, 6, GREEN);
                }
            if (eq.freqDataInt[i] > 600){
                uLCD.filled_circle(22+i*14, 22, 6, GREEN);
                }
            }
        lcd_mutex.unlock();
    }
}
     
void lighting_thread(){
          while(1){
            red = 0.5;
            green = 0;
            blue = 0;
            Thread::wait(638.297872);
            red = 0;
            green = 0.5;
            blue = 0;
            Thread::wait(638.297872);
            red = 0;
            green = 0;
            blue = 0.5;
            Thread::wait(638.297872);
            red = 0.5;
            green = 0.5;
            blue = 0;
            Thread::wait(638.297872);
            red = 0.5;
            blue = 0;
            green = 0.5;
            Thread::wait(638.297872);
            red = 0;
            blue = 0.5;
            green = 0.5;
            Thread::wait(638.297872);
           }
    }

    

int main() {
        music.start(music_thread);
        image.start(image_thread);
        info.start(info_thread);
        Lighting.start(lighting_thread);
    }