// Hello World! for the TextLCD

#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(p22, p16, p17, p18, p19, p20, TextLCD::LCD16x2); // rs, e, d4-d7
Serial ftdi(USBTX, USBRX);
DigitalIn crash(p21); //crash sensor input (high/low);
LocalFileSystem local("local");      // define local file system

BusOut myleds(LED1,LED2,LED3, LED4);  //

AnalogIn adc1(p15);  //ADC, speed sensor
float speed=0;

int count=0;                         // button count 
struct tm t;                         // declaring RTC. current time will be stored here



int main() {
    lcd.printf("Welcome!\n");
    //setting RTC and initializing RTC
    t.tm_year = 2015;     // current year
    t.tm_mon = 7;         // current month
    t.tm_mday = 7;        // current day
    t.tm_hour = 15;       // current hour
    t.tm_min = 16;        // current minute
    t.tm_sec = 0;         // current second   
    t.tm_year = t.tm_year - 1900;   // adjust for tm structure required values
    t.tm_mon = t.tm_mon - 1;
    set_time(mktime(&t));           // set the time
    
    FILE* Logfile = fopen ("/local/log.txt","w");
    fclose(Logfile);
    
    
        
    while(1) 
    {
        time_t seconds = time(NULL);
        if(crash.read()==0)          // if the button is pressed
        {   
            while(crash.read()==0);  // wait until release
            wait_ms(20);              // button debounce
            count++;                  // count up
            
            speed=adc1*120;
            
            ftdi.printf("Time: %s \rcount: %d \r\nSpeed: %f \r\n",ctime(&seconds),count, speed);         // send data to terminal
            ftdi.printf("-------------------------- \r\n");
            myleds=count; //display count on LED
            lcd.cls();
            lcd.printf("Speed: %0.1f \n",speed); //display speed on LCD
            
            
            FILE* Logfile = fopen ("/local/log.txt","a");                                  // open file for appending  
            
            fprintf(Logfile, "Time: %s \rcount: %d \r\nSpeed: %f \r\n",ctime(&seconds),count, speed);    // save data to log.txt file
            fprintf(Logfile, "-------------------------- \r\n");
            fclose(Logfile);  
            }
            else
            {
                myleds=0;
                wait(1);
                myleds=10;
                wait(1);
                }
                
         }  
    
}
