#pragma once 

#include "CNLib.h"

#define TIMEOUT_RETRY_DATA_CONNECTION           (5 * 1000)  //!< timeout for bringing up data in case of faults
#define TIMEOUT_CHECK_STATUS_DATA_CONNECITION   (5 * 1000)  //!< timeout for checking data connection status
#define TIMEOUT_POLLING_NETWORK_STATUS          (5 * 1000)  //!< timeout for polling the network status
#define MAX_ERROR_RETRIES                       5           //!< number of error before reset
#define SIM_WAIT_MAX_CYCLE                      15          //!< wait cycle for sim init
#define MEX_RESP_ERROR                          5

//! Manager events
typedef enum {    
    MNG_EV_IDLE,               //!< idle
    MNG_EV_DATA_UP,            //!< data connection is active
    MNG_EV_DATA_DOWN,            //!< data connection is active
} MngEvents;


/** Function handler for data status updates
  /param ev new data status
  /param param void pointer
*/
typedef void (*evMngHandler) (MngEvents ev, void* param);

/** Init Function
  This function has to be called before CNMLoop
   \param powerOn        module power status at boot: enabled on, disabled off
   \param dataEnabled    data connection status at boot: enabled on, disabled off
   \param roomingEnabled unsolicited messages status: enabled on, disabled off
   \return true if successful false otherwise
 */
bool cnInit(bool powerOn = true, bool dataEnabled = true, bool roomingEnabled = true);

/**Handler registration
   
    \param handler   Handler for data status changes
    \param param     void paramter to be passed to the handler
*/
void cnRegHandler(evMngHandler handler, void* param=NULL);

/** Set the debug level.
  This function has to be called before CNMLoop
   \param level -1 = OFF, 0 = ERROR, 1 = INFO(default), 2 = TRACE, 3 = ATCMD,TEST
   \return true if successful, false not possible
 */
bool cnSetDebug(int level);

/** Cycle the connection manager loop.
*   \return true if successful, false otherwise
*/
int cnLoop();

/** force module reset.
 This function can be called at any time.
 Force the reset of the connection manager and of the module.
 */
void cnReset();

/** Set the module power.
  This function can be called at any time.
   \param on if true the module is switched on, if false is switched off
 */
void cnSetPower(bool on);

/** Register (Attach) the MT to the GPRS service.
 This function can be called at any time.
   \param enabled if true data connection is requested, if false not.
 */
void cnSetDataEnabled(bool enabled);

/** Set parameters for the GPRS service.
This function has to be called before CNMLoop.
If Apn parameters are not set, the internal APN info database will be used.
 \param apn the of the network provider e.g. "internet" or "apn.provider.com"
 \param username is the user name text string for the authentication phase
 \param password is the password text string for the authentication phase
 \param auth is the authentication mode (CHAP,PAP,NONE or DETECT)
 */
void cnSetApn(const char *apn,const char* username = NULL,const char* password = NULL);

/** Set Sim pin for unlocking the sim
  This function has to be called prior to CNMLoop.
  \param pin of the SIM card
 */
void cnSetSimPin(const char* pin);

/** Set if rooming is allowed.
  \param enabled if true rooming is allowed, false it is not
 */
void cnSetRoamingOn(bool enabled);

/** Get data connection status.
 * \return yes if connection is up, false otherways
 */
bool cnIsDataUp();

/** Get the MDM library's pointer.
 * \return the MDM pointer
 */
MDMSerial* cnGetMDM();

/** Get a copy of NetStatus.
 * \param net pointer where NetStatus will be copied into
 */
void getNetStatus(MDMParser::NetStatus* net);

/** Get a copy of DevStatus.
 * \param dev pointer where DevStatus will be copied into
 */
void getDevStatus(MDMParser::DevStatus* dev);