#pragma once 

#include "CNManager.h"
#include "CNUtil.h"

//! Registration Status
typedef enum{
    REG_NO_CHANGES = 0,       //!< No changes
    REG_NOT_REGISTERED = 1,   //!< Not registered
    REG_REGISTERED = 2,       //!< Registered
} RegStatus;

/** Reg Init 
  This function has to be called prior to cnRegLoop
 */
void cnRegInit();

/** Loop registration module
  \param lib pointer to CN library
  \param regStatus [output] registration status
 */
CNResp cnRegLoop(CNLib* lib, RegStatus* status);

/** Reset
 */
void cnRegReset();

/** Set if Roaming is allowed
  \param enabled if true rooming is allowed, false it is not
 */
void cnRegSetRoaming(bool enabled);